/**ABDB**/CREATE TABLE `#__workflows` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_extension` (`extension`),
  KEY `idx_default` (`default`),
  KEY `idx_created` (`created`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_modified` (`modified`),
  KEY `idx_modified_by` (`modified_by`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflows`  VALUES 
('1', '56', '1', 'COM_WORKFLOW_BASIC_WORKFLOW', '', 'com_content.article', '1', '1', '2023-08-20 07:05:34', '376', '2023-08-20 07:05:34', '376', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_transitions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `workflow_id` int NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_stage_id` int NOT NULL,
  `to_stage_id` int NOT NULL,
  `options` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_from_stage_id` (`from_stage_id`),
  KEY `idx_to_stage_id` (`to_stage_id`),
  KEY `idx_workflow_id` (`workflow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_transitions`  VALUES 
('1', '58', '1', '1', '1', 'UNPUBLISH', '', '-1', '1', '{\"publishing\":\"0\"}', NULL, NULL),
('2', '59', '2', '1', '1', 'PUBLISH', '', '-1', '1', '{\"publishing\":\"1\"}', NULL, NULL),
('3', '60', '3', '1', '1', 'TRASH', '', '-1', '1', '{\"publishing\":\"-2\"}', NULL, NULL),
('4', '61', '4', '1', '1', 'ARCHIVE', '', '-1', '1', '{\"publishing\":\"2\"}', NULL, NULL),
('5', '62', '5', '1', '1', 'FEATURE', '', '-1', '1', '{\"featuring\":\"1\"}', NULL, NULL),
('6', '63', '6', '1', '1', 'UNFEATURE', '', '-1', '1', '{\"featuring\":\"0\"}', NULL, NULL),
('7', '64', '7', '1', '1', 'PUBLISH_AND_FEATURE', '', '-1', '1', '{\"publishing\":\"1\",\"featuring\":\"1\"}', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_stages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `workflow_id` int NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_workflow_id` (`workflow_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_default` (`default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_stages`  VALUES 
('1', '57', '1', '1', '1', 'COM_WORKFLOW_BASIC_STAGE', '', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_associations` (
  `item_id` int NOT NULL DEFAULT '0' COMMENT 'Extension table id value',
  `stage_id` int NOT NULL COMMENT 'Foreign Key to #__workflow_stages.id',
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`,`extension`),
  KEY `idx_item_stage_extension` (`item_id`,`stage_id`,`extension`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_stage_id` (`stage_id`),
  KEY `idx_extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_associations`  VALUES 
('1', '1', 'com_content.article'),
('2', '1', 'com_content.article'),
('3', '1', 'com_content.article'),
('4', '1', 'com_content.article'),
('5', '1', 'com_content.article'),
('6', '1', 'com_content.article'),
('7', '1', 'com_content.article'),
('8', '1', 'com_content.article'),
('9', '1', 'com_content.article');
/**ABDB**/CREATE TABLE `#__webauthn_credentials` (
  `id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential ID',
  `user_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'User handle',
  `label` varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Human readable label',
  `credential` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential source data, JSON format',
  PRIMARY KEY (`id`(100)),
  KEY `user_id` (`user_id`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int NOT NULL DEFAULT '0',
  `rules` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '2', '[6,2,8]'),
('3', 'Special', '3', '[6,3,8]'),
('5', 'Guest', '1', '[9]'),
('6', 'Super Users', '4', '[8]');
/**ABDB**/CREATE TABLE `#__users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block` tinyint NOT NULL DEFAULT '0',
  `sendEmail` tinyint DEFAULT '0',
  `registerDate` datetime NOT NULL,
  `lastvisitDate` datetime DEFAULT NULL,
  `activation` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastResetTime` datetime DEFAULT NULL COMMENT 'Date of last password reset',
  `resetCount` int NOT NULL DEFAULT '0' COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Backup Codes',
  `requireReset` tinyint NOT NULL DEFAULT '0' COMMENT 'Require user to reset password on next login',
  `authProvider` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Name of used authentication plugin',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_name` (`name`(100)),
  KEY `idx_block` (`block`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=965 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('376', 'Admin', 'admin', 'admin@admin.com', '$2y$10$verI.UQpUI10ZY755KFiQeoSyCvup3Cmcq5DodaDAkrL9rBuUIBmG', '0', '1', '2024-04-29 09:03:01', '2024-04-30 07:55:58', '0', '', NULL, '0', '', '', '0', '');
/**ABDB**/CREATE TABLE `#__usergroups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Adjacency List Reference Id',
  `lft` int NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__usergroups`  VALUES 
('1', '0', '1', '18', 'Public'),
('2', '1', '8', '15', 'Registered'),
('3', '2', '9', '14', 'Author'),
('4', '3', '10', '13', 'Editor'),
('5', '4', '11', '12', 'Publisher'),
('6', '1', '4', '7', 'Manager'),
('7', '6', '5', '6', 'Administrator'),
('8', '1', '16', '17', 'Super Users'),
('9', '1', '2', '3', 'Guest');
/**ABDB**/CREATE TABLE `#__user_usergroup_map` (
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__users.id',
  `group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__user_usergroup_map`  VALUES 
('14', '8'),
('376', '8'),
('647', '8'),
('679', '8'),
('964', '8');
/**ABDB**/CREATE TABLE `#__user_profiles` (
  `user_id` int NOT NULL,
  `profile_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `modified_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `review_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__user_mfa` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint NOT NULL DEFAULT '0',
  `options` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_on` datetime NOT NULL,
  `last_used` datetime DEFAULT NULL,
  `tries` int NOT NULL DEFAULT '0',
  `last_try` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Multi-factor Authentication settings';
/**ABDB**/CREATE TABLE `#__user_keys` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `series` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `uastring` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__updates` (
  `update_id` int NOT NULL AUTO_INCREMENT,
  `update_site_id` int DEFAULT '0',
  `extension_id` int DEFAULT '0',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint DEFAULT '0',
  `version` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `extra_query` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=253 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `#__updates`  VALUES 
('209', '2', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '5.0.2.1', '', 'https://update.joomla.org/language/details5/af-ZA_details.xml', '', '', ''),
('210', '2', '0', 'Belarusian', '', 'pkg_be-BY', 'package', '', '0', '5.0.2.1', '', 'https://update.joomla.org/language/details5/be-BY_details.xml', '', '', ''),
('211', '2', '0', 'Chinese, Traditional', '', 'pkg_zh-TW', 'package', '', '0', '5.0.3.1', '', 'https://update.joomla.org/language/details5/zh-TW_details.xml', '', '', ''),
('212', '2', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '5.0.0.1', '', 'https://update.joomla.org/language/details5/cs-CZ_details.xml', '', '', ''),
('213', '2', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '5.0.3.1', '', 'https://update.joomla.org/language/details5/da-DK_details.xml', '', '', ''),
('214', '2', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '5.1.0.3', '', 'https://update.joomla.org/language/details5/nl-NL_details.xml', '', '', ''),
('215', '2', '0', 'English, Australia', '', 'pkg_en-AU', 'package', '', '0', '5.0.3.1', '', 'https://update.joomla.org/language/details5/en-AU_details.xml', '', '', ''),
('216', '2', '0', 'English, Canada', '', 'pkg_en-CA', 'package', '', '0', '5.0.3.1', '', 'https://update.joomla.org/language/details5/en-CA_details.xml', '', '', ''),
('217', '2', '0', 'English, New Zealand', '', 'pkg_en-NZ', 'package', '', '0', '5.0.3.2', '', 'https://update.joomla.org/language/details5/en-NZ_details.xml', '', '', ''),
('218', '2', '0', 'English, USA', '', 'pkg_en-US', 'package', '', '0', '5.0.3.1', '', 'https://update.joomla.org/language/details5/en-US_details.xml', '', '', ''),
('219', '2', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/et-EE_details.xml', '', '', ''),
('220', '2', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '5.0.3.1', '', 'https://update.joomla.org/language/details5/fi-FI_details.xml', '', '', ''),
('221', '2', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/nl-BE_details.xml', '', '', ''),
('222', '2', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/fr-FR_details.xml', '', '', ''),
('223', '2', '0', 'French, Canada', '', 'pkg_fr-CA', 'package', '', '0', '5.0.3.1', '', 'https://update.joomla.org/language/details5/fr-CA_details.xml', '', '', ''),
('224', '2', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/ka-GE_details.xml', '', '', ''),
('225', '2', '0', 'German', '', 'pkg_de-DE', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/de-DE_details.xml', '', '', ''),
('226', '2', '0', 'German, Austria', '', 'pkg_de-AT', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/de-AT_details.xml', '', '', ''),
('227', '2', '0', 'German, Liechtenstein', '', 'pkg_de-LI', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/de-LI_details.xml', '', '', ''),
('228', '2', '0', 'German, Luxembourg', '', 'pkg_de-LU', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/de-LU_details.xml', '', '', ''),
('229', '2', '0', 'German, Switzerland', '', 'pkg_de-CH', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/de-CH_details.xml', '', '', ''),
('230', '2', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/el-GR_details.xml', '', '', ''),
('231', '2', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '5.1.0.2', '', 'https://update.joomla.org/language/details5/hu-HU_details.xml', '', '', ''),
('232', '2', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/it-IT_details.xml', '', '', ''),
('233', '2', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/ja-JP_details.xml', '', '', ''),
('234', '2', '0', 'Kazakh', '', 'pkg_kk-KZ', 'package', '', '0', '5.0.0.4', '', 'https://update.joomla.org/language/details5/kk-KZ_details.xml', '', '', ''),
('235', '2', '0', 'Korean', '', 'pkg_ko-KR', 'package', '', '0', '5.0.2.1', '', 'https://update.joomla.org/language/details5/ko-KR_details.xml', '', '', ''),
('236', '2', '0', 'Latvian', '', 'pkg_lv-LV', 'package', '', '0', '5.0.1.1', '', 'https://update.joomla.org/language/details5/lv-LV_details.xml', '', '', ''),
('237', '2', '0', 'Pashto Afghanistan', '', 'pkg_ps-AF', 'package', '', '0', '5.0.1.1', '', 'https://update.joomla.org/language/details5/ps-AF_details.xml', '', '', ''),
('238', '2', '0', 'Persian Farsi', '', 'pkg_fa-IR', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/fa-IR_details.xml', '', '', ''),
('239', '2', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '5.0.3.1', '', 'https://update.joomla.org/language/details5/pl-PL_details.xml', '', '', ''),
('240', '2', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '5.0.1.1', '', 'https://update.joomla.org/language/details5/ro-RO_details.xml', '', '', ''),
('241', '2', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '5.1.0.3', '', 'https://update.joomla.org/language/details5/ru-RU_details.xml', '', '', ''),
('242', '2', '0', 'Serbian, Latin', '', 'pkg_sr-YU', 'package', '', '0', '5.1.0.3', '', 'https://update.joomla.org/language/details5/sr-YU_details.xml', '', '', ''),
('243', '2', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '5.0.1.2', '', 'https://update.joomla.org/language/details5/sk-SK_details.xml', '', '', ''),
('244', '2', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/sl-SI_details.xml', '', '', ''),
('245', '2', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/es-ES_details.xml', '', '', ''),
('246', '2', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/sv-SE_details.xml', '', '', ''),
('247', '2', '0', 'Tamil, India', '', 'pkg_ta-IN', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/ta-IN_details.xml', '', '', ''),
('248', '2', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/th-TH_details.xml', '', '', ''),
('249', '2', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/tr-TR_details.xml', '', '', ''),
('250', '2', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '5.0.1.1', '', 'https://update.joomla.org/language/details5/uk-UA_details.xml', '', '', ''),
('251', '2', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '5.1.0.2', '', 'https://update.joomla.org/language/details5/cy-GB_details.xml', '', '', ''),
('252', '5', '0', 'shaper_helixultimate', 'Helix Ultimate', 'shaper_helixultimate', 'template', '', '0', '2.0.18', '', 'https://www.joomshaper.com/updates/shaper-helixultimate.xml', '', NULL, '');
/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int NOT NULL DEFAULT '0',
  `extension_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '227'),
('2', '228'),
('3', '24'),
('4', '232'),
('5', '261'),
('6', '235'),
('7', '254'),
('8', '255'),
('11', '300');
/**ABDB**/CREATE TABLE `#__update_sites` (
  `update_site_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int DEFAULT '0',
  `last_check_timestamp` bigint DEFAULT '0',
  `extra_query` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `#__update_sites`  VALUES 
('1', 'Joomla! Core', 'tuf', 'https://update.joomla.org/cms/', '1', '1714463765', '', NULL, NULL),
('2', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_5.xml', '1', '1714463766', '', NULL, NULL),
('3', 'Joomla! Update Component', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1714463767', '', NULL, NULL),
('4', 'System - Helix Ultimate Framework', 'extension', 'http://www.joomshaper.com/updates/plg-system-helixultimate.xml', '1', '1714463767', '', NULL, NULL),
('5', 'shaper_helixultimate', 'extension', 'https://www.joomshaper.com/updates/shaper-helixultimate.xml', '1', '1714463768', '', NULL, NULL),
('6', 'iQuix', 'extension', 'https://raw.githubusercontent.com/themexpert/iquix/master/mainfest.xml', '1', '1714463768', '', NULL, NULL),
('7', 'JMedia Update Site', 'extension', 'https://www.themexpert.com/index.php?option=com_digicom&task=responses&source=release&format=xml&provider=joomla&pid=224', '1', '1714463769', '', NULL, NULL),
('8', 'Quix Update Site', 'extension', 'https://www.themexpert.com/index.php?option=com_digicom&task=responses&source=release&format=xml&provider=joomla&pid=116', '1', '1714463770', 'username=swopnil&key=dfa41e2e70d48707bcbe1a33e47f7dcd&activated=1', NULL, NULL),
('11', 'Akeeba Backup Core for Joomla!', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', '1', '0', '', NULL, NULL);
/**ABDB**/CREATE TABLE `#__ucm_content` (
  `core_content_id` int unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_state` tinyint NOT NULL DEFAULT '0',
  `core_checked_out_time` datetime DEFAULT NULL,
  `core_checked_out_user_id` int unsigned DEFAULT NULL,
  `core_access` int unsigned NOT NULL DEFAULT '0',
  `core_params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL,
  `core_modified_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL,
  `core_language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime DEFAULT NULL,
  `core_publish_down` datetime DEFAULT NULL,
  `core_content_item_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'ID from the individual type table',
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `core_images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_urls` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_hits` int unsigned NOT NULL DEFAULT '0',
  `core_version` int unsigned NOT NULL DEFAULT '1',
  `core_ordering` int NOT NULL DEFAULT '0',
  `core_metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_catid` int unsigned NOT NULL DEFAULT '0',
  `core_type_id` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`(100)),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';
/**ABDB**/CREATE TABLE `#__ucm_base` (
  `ucm_id` int unsigned NOT NULL,
  `ucm_item_id` int NOT NULL,
  `ucm_type_id` int NOT NULL,
  `ucm_language_id` int NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__tuf_metadata` (
  `id` int NOT NULL AUTO_INCREMENT,
  `update_site_id` int DEFAULT '0',
  `root` text COLLATE utf8mb4_unicode_ci,
  `targets` text COLLATE utf8mb4_unicode_ci,
  `snapshot` text COLLATE utf8mb4_unicode_ci,
  `timestamp` text COLLATE utf8mb4_unicode_ci,
  `mirrors` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Secure TUF Updates';
/**ABDB**/INSERT INTO `#__tuf_metadata`  VALUES 
('1', '1', '{\"signed\":{\"_type\":\"root\",\"spec_version\":\"1.0\",\"version\":4,\"expires\":\"2025-03-02T16:38:55Z\",\"keys\":{\"07eb082f367c034a95878687f6648aa76d93652b6ee73e58817053d89af6c44f\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"9b2af2d9b9727227735253d795bd27ea8f0e294a5f3603e822dc5052b44802b9\"}},\"1b1b1dd55b2c1c7258714cf1c1ae06f23e4607b28c762d016a9d81c48ffe5669\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"a18e5ebabc19d5d5984b601a292ece61ba3662ab2d071dc520da5bd4f8948799\"}},\"2dcaf3d0e552f150792f7c636d45429246dcfa34ac35b46a44f5c87cd17d457e\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"cb0a7a131961a20edea051d6dc2b091fb650bd399bd8514adb67b3c60db9f8f9\"}},\"31dd7c7290d664c9b88c0dead2697175293ea7df81b7f24153a37370fd3901c3\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"589d029a68b470deff1ca16dbf3eea6b5b3fcba0ae7bb52c468abc7fb058b2a2\"}},\"9e41a9d62d94c6a1c8a304f62c5bd72d84a9f286f27e8327cedeacb09e5156cc\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"6043c8bacc76ac5c9750f45454dd865c6ca1fc57d69e14cc192cfd420f6a66a9\"}},\"e2229942b0fc1e6d7f82adf258e5bdadac10046d1470b7ec459c9eb4e076026b\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"ad1950e117b29ebe7a38635a2e574123e07571e4f9a011783e053b5f15d2562a\"}},\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"5d451915bc2b93a0e4e4745bc6a8b292d58996d50e0fb66c78c7827152a65879\"}}},\"roles\":{\"root\":{\"keyids\":[\"1b1b1dd55b2c1c7258714cf1c1ae06f23e4607b28c762d016a9d81c48ffe5669\",\"2dcaf3d0e552f150792f7c636d45429246dcfa34ac35b46a44f5c87cd17d457e\"],\"threshold\":1},\"snapshot\":{\"keyids\":[\"07eb082f367c034a95878687f6648aa76d93652b6ee73e58817053d89af6c44f\",\"2dcaf3d0e552f150792f7c636d45429246dcfa34ac35b46a44f5c87cd17d457e\",\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\",\"e2229942b0fc1e6d7f82adf258e5bdadac10046d1470b7ec459c9eb4e076026b\"],\"threshold\":1},\"targets\":{\"keyids\":[\"31dd7c7290d664c9b88c0dead2697175293ea7df81b7f24153a37370fd3901c3\",\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\",\"e2229942b0fc1e6d7f82adf258e5bdadac10046d1470b7ec459c9eb4e076026b\"],\"threshold\":1},\"timestamp\":{\"keyids\":[\"9e41a9d62d94c6a1c8a304f62c5bd72d84a9f286f27e8327cedeacb09e5156cc\"],\"threshold\":1}},\"consistent_snapshot\":true},\"signatures\":[{\"keyid\":\"1b1b1dd55b2c1c7258714cf1c1ae06f23e4607b28c762d016a9d81c48ffe5669\",\"sig\":\"1c8060aab4c5290dc398199d8f124701bd3f7d3fb47d688e3e61d20eeb90d6e387556ce680ba8db9b99f15332df64da349a03344f50ab4f1fe491efdf88f170c\"}]}', '{\"signed\":{\"_type\":\"targets\",\"spec_version\":\"1.0\",\"version\":8,\"expires\":\"2025-05-16T09:53:47Z\",\"targets\":{\"Joomla_5.1.0-Stable-Update_Package.zip\":{\"length\":28072588,\"hashes\":{\"sha512\":\"996f07b3075b743216a751f80e37d813e36feb090fd8d2162b52723b80e5e5d23608b829c86f3c54044e19ab260aacca13ea7aee978676c31c4b1a2518a5551f\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.1.0 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.1.0/Joomla_5.1.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.1.0/Joomla_5.1.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-1-0/Joomla_5.1.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5906-joomla-5-1-and-joomla-4-4-4-are-here.html\",\"title\":\"Joomla! 5.1.0 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.1.0\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.1.0\"}}}},\"signatures\":[{\"keyid\":\"31dd7c7290d664c9b88c0dead2697175293ea7df81b7f24153a37370fd3901c3\",\"sig\":\"7be4fcb30935e0a2cf1d117aa3ed1325bbc433a6aafee0ae050a900a261963036ee52f1100ca165e80c3df9a8df74c4e10cd25f82e828ed77c7ec9ef35ae8404\"},{\"keyid\":\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\",\"sig\":\"cabd6316e8e917f8b49f40822d419bc39bfe6974072b801a2bf0eab474a9df9b7552ecf045a092f5747872c7fcf9b3e9c448ff4770148432dd2a54df093a300f\"}]}', '{\"signed\":{\"_type\":\"snapshot\",\"spec_version\":\"1.0\",\"version\":11,\"expires\":\"2024-11-12T15:59:34Z\",\"meta\":{\"targets.json\":{\"length\":1739,\"hashes\":{\"sha512\":\"fef8a860ce95b2e059ca2fbc18106f7a3efc9c2f8200b66c7b9f8234774afd6426c3fb4fe82879031c2ab31fc41104fc6512370f9c1bbb24cf85b8b89cc135fc\"},\"version\":8}}},\"signatures\":[{\"keyid\":\"07eb082f367c034a95878687f6648aa76d93652b6ee73e58817053d89af6c44f\",\"sig\":\"d0a17a6a1d86c01c221ce952558ace7223714be94b63490bc7c41558c9dbbabd61e45b51a57e6b6c93bb8d1e033c7d920c932627b7ab3971d4e3166f2964f008\"}]}', '{\"signed\":{\"_type\":\"timestamp\",\"spec_version\":\"1.0\",\"version\":115,\"expires\":\"2024-05-02T01:17:02Z\",\"meta\":{\"snapshot.json\":{\"length\":530,\"hashes\":{\"sha512\":\"d203254f713475ae6110b521d616c3352ce76e08bcb16ca5aaa9bf6a75a46438eaa71f62235ce5d7f1458f37c78fcff0187693c7e403ed24fd07fee3f2e0e33e\"},\"version\":11}}},\"signatures\":[{\"keyid\":\"9e41a9d62d94c6a1c8a304f62c5bd72d84a9f286f27e8327cedeacb09e5156cc\",\"sig\":\"e3c60db991050e08f527328546e921c1009693dbc95a0bea02749c970908678d843fec01840a1a17d03aea63dca3364abf9162b9166c4cc86001f382d44b4207\"}]}', NULL);
/**ABDB**/CREATE TABLE `#__template_styles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint unsigned NOT NULL DEFAULT '0',
  `home` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `inheritable` tinyint NOT NULL DEFAULT '0',
  `parent` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_styles`  VALUES 
('10', 'atum', '1', '1', 'Atum - Default', '1', '', '{\"hue\":\"hsl(214, 63%, 20%)\",\"bg-light\":\"#f0f4fb\",\"text-dark\":\"#495057\",\"text-light\":\"#ffffff\",\"link-color\":\"#2a69b8\",\"special-color\":\"#001b4c\",\"monochrome\":\"0\",\"loginLogo\":\"\",\"loginLogoAlt\":\"\",\"logoBrandLarge\":\"\",\"logoBrandLargeAlt\":\"\",\"logoBrandSmall\":\"\",\"logoBrandSmallAlt\":\"\"}'),
('11', 'cassiopeia', '0', '0', 'Cassiopeia - Default', '1', '', '{\"brand\":\"1\",\"logoFile\":\"\",\"siteTitle\":\"\",\"siteDescription\":\"\",\"useFontScheme\":\"0\",\"colorName\":\"colors_standard\",\"fluidContainer\":\"0\",\"stickyHeader\":0,\"backTop\":0}'),
('13', 'atom', '0', '0', 'Atom - Default', '0', '', '{\"logo_type\":\"svg\",\"logoFile\":\"\",\"sitetitle\":\"\",\"primaryColor\":\"\",\"secondaryColor\":\"\",\"layout\":\"0\",\"layoutWidth\":\"80\",\"layoutBackgroundcolor\":\"#fff\",\"hide_nav\":\"1\",\"hide_footer\":\"1\",\"http2_push\":\"1\",\"reduceHttp\":\"1\"}'),
('16', 'tx_elevate', '0', '1', 'tx_elevate - Default', '0', '', '{\"logo_type\":\"image\",\"logo_image\":\"images\\/logo.png\",\"retina_logo\":\"\",\"mobile_logo\":\"\",\"logo_alt\":\"\",\"logo_custom_link\":\"\",\"logo_height\":\"36px\",\"logo_height_sm\":\"36px\",\"logo_height_xs\":\"36px\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"images\\/favicon.ico\",\"predefined_header\":\"1\",\"header_style\":\"5-FullwidthCenter\",\"header_height\":\"90px\",\"header_height_sm\":\"\",\"header_height_xs\":\"50px\",\"enable_login\":\"1\",\"sticky_header\":\"1\",\"sticky_offset\":\"\",\"loader_type\":\"circle\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 {year} Your Company. Designed By ThemeXpert\",\"goto_top\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"facebook\":\"#\",\"twitter\":\"#\",\"pinterest\":\"#\",\"linkedin\":\"#\",\"dribbble\":\"#\",\"instagram\":\"#\",\"behance\":\"#\",\"youtube\":\"#\",\"flickr\":\"#\",\"skype\":\"pq.softs\",\"whatsapp\":\"#\",\"vk\":\"#\",\"custom\":\"\",\"contactinfo\":\"1\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"+228 872 4444\",\"contact_mobile\":\"+775 872 4444\",\"contact_email\":\"contact@email.com\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"2025-01-01\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"\",\"error_bg\":\"\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#0345BF\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0345BF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0345BF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_text_active_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0345BF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"preset\\\":\\\"preset1\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#ec430f\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#0fa89d\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"bg_color\\\":\\\"#ffffff\\\",\\\"link_color\\\":\\\"#2C5F2D\\\",\\\"link_hover_color\\\":\\\"#fff\\\",\\\"header_bg_color\\\":\\\"#ffffff\\\",\\\"topbar_bg_color\\\":\\\"#03a83a\\\",\\\"topbar_text_color\\\":\\\"#ffffff\\\",\\\"logo_text_color\\\":\\\"#2C5F2D\\\",\\\"menu_text_color\\\":\\\"#03a83a\\\",\\\"menu_text_hover_color\\\":\\\"#030000\\\",\\\"menu_text_active_color\\\":\\\"#063803\\\",\\\"menu_dropdown_bg_color\\\":\\\"#2C5F2D\\\",\\\"menu_dropdown_text_color\\\":\\\"#2C5F2D\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2C5F2D\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2C5F2D\\\",\\\"footer_bg_color\\\":\\\"#2C5F2D\\\",\\\"footer_text_color\\\":\\\"#2C5F2D\\\",\\\"footer_link_color\\\":\\\"#2C5F2D\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#4943ac\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset4\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4943ac\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4943ac\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_text_active_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4943ac\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset5\\\":{\\\"label\\\":\\\"Preset 5\\\",\\\"default\\\":\\\"#00aeef\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset5\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00aeef\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00aeef\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_text_active_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#00aeef\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset6\\\":{\\\"label\\\":\\\"Preset 6\\\",\\\"default\\\":\\\"#f68e13\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset6\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#f68e13\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#f68e13\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_text_active_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f68e13\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset7\\\":{\\\"label\\\":\\\"Preset 7\\\",\\\"default\\\":\\\"#2ba84a\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset7\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#2ba84a\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#2ba84a\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_text_active_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2ba84a\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset8\\\":{\\\"label\\\":\\\"Preset 8\\\",\\\"default\\\":\\\"#ed145b\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset8\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ed145b\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ed145b\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_text_active_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ed145b\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset9\\\":{\\\"label\\\":\\\"Preset 9\\\",\\\"default\\\":\\\"#00194C\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#3f4654\\\",\\\"preset\\\":\\\"preset9\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00194C\\\",\\\"link_hover_color\\\":\\\"#5445FF\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00194C\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#5445FF\\\",\\\"menu_text_active_color\\\":\\\"#5445FF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#5445FF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#5445FF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#5445FF\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#5445FF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_text_active_color\\\":\\\"#5445FF\\\",\\\"menu_text_hover_color\\\":\\\"#5445FF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"logo_text_color\\\":\\\"#00194C\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"link_hover_color\\\":\\\"#5445FF\\\",\\\"link_color\\\":\\\"#00194C\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"text_color\\\":\\\"#3f4654\\\",\\\"preset\\\":\\\"preset9\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#2b2b2b\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"offcanvas_menu_icon_color\":\"#000000\",\"offcanvas_menu_bg_color\":\"#ffffff\",\"offcanvas_menu_items_and_items_color\":\"#252525\",\"offcanvas_menu_active_menu_item_color\":\"#252525\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_desktop\\\":0,\\\"hide_small_desktop\\\":0,\\\"hide_tablet\\\":0,\\\"hide_large_mobile\\\":1,\\\"hide_mobile\\\":1,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"name\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"title\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":12,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"Main Body\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"left\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"grid_size\\\":4}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"right\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"3+3+3+3\\\",\\\"settings\\\":{\\\"name\\\":\\\"Bottom\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0,\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"column_type\\\":0,\\\"name\\\":\\\"bottom1\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"col-sm-6\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"grid_size\\\":3}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"col-sm-6\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"bottom2\\\",\\\"column_type\\\":0,\\\"grid_size\\\":3}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":3,\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"bottom3\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":3,\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"bottom4\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"6+6\\\",\\\"settings\\\":{\\\"name\\\":\\\"Footer\\\",\\\"background_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"grid_size\\\":6,\\\"column_type\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":6,\\\"column_type\\\":0,\\\"name\\\":\\\"footer2\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-animation-fade-up\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"1-LeftAlign\",\"offcanvas_menu\":\"mainmenu\",\"offcanvas_max_level\":\"0\",\"enable_body_font\":\"1\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Roboto\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h1_font\":\"1\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Roboto Slab\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h2_font\":\"1\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Roboto Slab\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h3_font\":\"1\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Rajdhani\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"devanagari\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_navigation_font\":\"1\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Roboto Slab\\\",\\\"fontSize\\\":\\\"18px\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"700\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"600X340\",\"image_small_size\":\"100X100\",\"image_medium_size\":\"300X300\",\"image_large_size\":\"600X600\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"thumbnail\",\"leading_blog_list_image\":\"large\",\"blog_details_image\":\"default\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article_title\":\"Related Articles\",\"related_article_column\":\"3\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disabled\",\"comment_disqus_subdomain\":\"\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"\",\"custom_js\":\"\",\"exclude_js\":\"\",\"scssoption\":\"1\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"\",\"id\":\"16\",\"template\":\"tx_elevate\",\"client_id\":\"0\",\"home\":\"1\",\"title\":\"tx_elevate - Default\"}'),
('17', 'tx_elevate', '0', '0', 'tx_elevate - Quix', '0', '', '{\"logo_type\":\"image\",\"logo_image\":\"images\\/logo.png\",\"retina_logo\":\"\",\"mobile_logo\":\"\",\"logo_alt\":\"\",\"logo_custom_link\":\"\",\"logo_height\":\"36px\",\"logo_height_sm\":\"36px\",\"logo_height_xs\":\"36px\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"images\\/favicon.ico\",\"predefined_header\":\"1\",\"header_style\":\"5-FullwidthCenter\",\"header_height\":\"90px\",\"header_height_sm\":\"\",\"header_height_xs\":\"50px\",\"enable_login\":\"1\",\"sticky_header\":\"1\",\"sticky_offset\":\"\",\"loader_type\":\"circle\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"enabled_copyright\":\"1\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"This Joomla 5 Template is sponsored by ThriveDesk\",\"goto_top\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"facebook\":\"#\",\"twitter\":\"#\",\"pinterest\":\"#\",\"linkedin\":\"#\",\"dribbble\":\"#\",\"instagram\":\"#\",\"behance\":\"#\",\"youtube\":\"#\",\"flickr\":\"#\",\"skype\":\"pq.softs\",\"whatsapp\":\"#\",\"vk\":\"#\",\"custom\":\"\",\"contactinfo\":\"1\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"+228 872 4444\",\"contact_mobile\":\"+775 872 4444\",\"contact_email\":\"contact@email.com\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"2025-01-01\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"\",\"error_bg\":\"\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#0345BF\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0345BF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0345BF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_text_active_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0345BF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"preset\\\":\\\"preset1\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#ec430f\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#0fa89d\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"bg_color\\\":\\\"#ffffff\\\",\\\"link_color\\\":\\\"#2C5F2D\\\",\\\"link_hover_color\\\":\\\"#fff\\\",\\\"header_bg_color\\\":\\\"#ffffff\\\",\\\"topbar_bg_color\\\":\\\"#03a83a\\\",\\\"topbar_text_color\\\":\\\"#ffffff\\\",\\\"logo_text_color\\\":\\\"#2C5F2D\\\",\\\"menu_text_color\\\":\\\"#03a83a\\\",\\\"menu_text_hover_color\\\":\\\"#030000\\\",\\\"menu_text_active_color\\\":\\\"#063803\\\",\\\"menu_dropdown_bg_color\\\":\\\"#2C5F2D\\\",\\\"menu_dropdown_text_color\\\":\\\"#2C5F2D\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2C5F2D\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2C5F2D\\\",\\\"footer_bg_color\\\":\\\"#2C5F2D\\\",\\\"footer_text_color\\\":\\\"#2C5F2D\\\",\\\"footer_link_color\\\":\\\"#2C5F2D\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#4943ac\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset4\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4943ac\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4943ac\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_text_active_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4943ac\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset5\\\":{\\\"label\\\":\\\"Preset 5\\\",\\\"default\\\":\\\"#00aeef\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset5\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00aeef\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00aeef\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_text_active_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#00aeef\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset6\\\":{\\\"label\\\":\\\"Preset 6\\\",\\\"default\\\":\\\"#f68e13\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset6\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#f68e13\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#f68e13\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_text_active_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f68e13\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset7\\\":{\\\"label\\\":\\\"Preset 7\\\",\\\"default\\\":\\\"#2ba84a\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset7\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#2ba84a\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#2ba84a\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_text_active_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2ba84a\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset8\\\":{\\\"label\\\":\\\"Preset 8\\\",\\\"default\\\":\\\"#ed145b\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset8\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ed145b\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ed145b\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_text_active_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ed145b\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset9\\\":{\\\"label\\\":\\\"Preset 9\\\",\\\"default\\\":\\\"#00194C\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#3f4654\\\",\\\"preset\\\":\\\"preset9\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00194C\\\",\\\"link_hover_color\\\":\\\"#5445FF\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00194C\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#5445FF\\\",\\\"menu_text_active_color\\\":\\\"#5445FF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#5445FF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#5445FF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#5445FF\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#5445FF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_text_active_color\\\":\\\"#5445FF\\\",\\\"menu_text_hover_color\\\":\\\"#5445FF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"logo_text_color\\\":\\\"#00194C\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"link_hover_color\\\":\\\"#5445FF\\\",\\\"link_color\\\":\\\"#00194C\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"text_color\\\":\\\"#3f4654\\\",\\\"preset\\\":\\\"preset9\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#2b2b2b\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"offcanvas_menu_icon_color\":\"#000000\",\"offcanvas_menu_bg_color\":\"#ffffff\",\"offcanvas_menu_items_and_items_color\":\"#252525\",\"offcanvas_menu_active_menu_item_color\":\"#252525\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_desktop\\\":0,\\\"hide_small_desktop\\\":0,\\\"hide_tablet\\\":0,\\\"hide_large_mobile\\\":1,\\\"hide_mobile\\\":1,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"name\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"title\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":12,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"Main Body\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"90px 0px 0px\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"left\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"grid_size\\\":4,\\\"column_type\\\":1,\\\"name\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"right\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"3+3+3+3\\\",\\\"settings\\\":{\\\"name\\\":\\\"Bottom\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0,\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"column_type\\\":0,\\\"name\\\":\\\"bottom1\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"col-sm-6\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"grid_size\\\":3}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"col-sm-6\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"bottom2\\\",\\\"column_type\\\":0,\\\"grid_size\\\":3}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":3,\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"bottom3\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":3,\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"bottom4\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"name\\\":\\\"Footer\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"0px\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"column_type\\\":0,\\\"grid_size\\\":12,\\\"sortableitem\\\":\\\"[object Object]\\\"}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-animation-fade-up\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"1-LeftAlign\",\"offcanvas_menu\":\"mainmenu\",\"offcanvas_max_level\":\"0\",\"enable_body_font\":\"1\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Roboto\\\",\\\"fontSize\\\":\\\"36px\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h1_font\":\"1\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Roboto Slab\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h2_font\":\"1\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Roboto Slab\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h3_font\":\"1\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Rajdhani\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"devanagari\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_navigation_font\":\"1\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Roboto Slab\\\",\\\"fontSize\\\":\\\"18px\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"700\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"600X340\",\"image_small_size\":\"100X100\",\"image_medium_size\":\"300X300\",\"image_large_size\":\"600X600\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"thumbnail\",\"leading_blog_list_image\":\"large\",\"blog_details_image\":\"default\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article_title\":\"Related Articles\",\"related_article_column\":\"3\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disabled\",\"comment_disqus_subdomain\":\"\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"\",\"custom_js\":\"\",\"exclude_js\":\"\",\"scssoption\":\"1\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"\",\"id\":\"17\",\"template\":\"tx_elevate\",\"client_id\":\"0\",\"home\":\"0\",\"title\":\"tx_elevate - Quix\"}');
/**ABDB**/CREATE TABLE `#__template_overrides` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hash_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension_id` int DEFAULT '0',
  `state` tinyint NOT NULL DEFAULT '0',
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint unsigned NOT NULL DEFAULT '0',
  `created_date` datetime NOT NULL,
  `modified_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_extension_id` (`extension_id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_overrides`  VALUES 
('1', 'atom', 'L2h0bWwvY29tX2NvbnRlbnQvYXJjaGl2ZS9kZWZhdWx0LnBocA==', '248', '1', 'Joomla Update', '0', '2023-08-26 04:20:08', '2023-08-26 04:20:08'),
('5', 'atom', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvYmxvZ19jaGlsZHJlbi5waHA=', '248', '0', 'Joomla Update', '0', '2023-11-07 03:53:38', '2023-11-07 04:24:39'),
('6', 'tx_elevate', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvYmxvZ19jaGlsZHJlbi5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 03:53:38', '2023-11-07 04:24:40'),
('7', 'atom', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvZGVmYXVsdF9jaGlsZHJlbi5waHA=', '248', '0', 'Joomla Update', '0', '2023-11-07 03:53:38', '2023-11-07 04:24:40'),
('8', 'tx_elevate', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvZGVmYXVsdF9jaGlsZHJlbi5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 03:53:38', '2023-11-07 04:24:40'),
('9', 'atom', 'L2h0bWwvY29tX2ZpbmRlci9zZWFyY2gvZGVmYXVsdF9yZXN1bHRzLnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 03:53:38', '2023-11-07 04:24:40'),
('10', 'tx_elevate', 'L2h0bWwvY29tX2ZpbmRlci9zZWFyY2gvZGVmYXVsdF9yZXN1bHRzLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 03:53:38', '2023-11-07 04:24:40'),
('11', 'atom', 'L2h0bWwvY29tX3VzZXJzL3Byb2ZpbGUvZWRpdC5waHA=', '248', '1', 'Joomla Update', '0', '2023-11-07 03:53:38', '2023-11-07 03:53:38'),
('12', 'tx_elevate', 'L2h0bWwvY29tX3VzZXJzL3Byb2ZpbGUvZWRpdC5waHA=', '261', '1', 'Joomla Update', '0', '2023-11-07 03:53:38', '2023-11-07 03:53:38'),
('13', 'atom', 'L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0LnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:39', '2023-11-07 04:24:39'),
('14', 'tx_elevate', 'L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0LnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:39', '2023-11-07 04:24:39'),
('15', 'atom', 'L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0X2FkZHJlc3MucGhw', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:39', '2024-04-29 09:09:23'),
('16', 'tx_elevate', 'L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0X2FkZHJlc3MucGhw', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:39', '2024-04-29 09:09:23'),
('17', 'atom', 'L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0X2xpbmtzLnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:39', '2024-04-29 09:09:23'),
('18', 'tx_elevate', 'L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0X2xpbmtzLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:39', '2024-04-29 09:09:23'),
('19', 'atom', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvYmxvZy5waHA=', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2024-04-29 09:09:23'),
('20', 'tx_elevate', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvYmxvZy5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2024-04-29 09:09:23'),
('21', 'atom', 'L2h0bWwvY29tX2NvbnRlbnQvYXJ0aWNsZS9kZWZhdWx0LnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2024-04-29 09:09:23'),
('22', 'tx_elevate', 'L2h0bWwvY29tX2NvbnRlbnQvYXJ0aWNsZS9kZWZhdWx0LnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2024-04-29 09:09:23'),
('23', 'atom', 'L2h0bWwvY29tX2NvbnRlbnQvYXJjaGl2ZS9kZWZhdWx0X2l0ZW1zLnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('24', 'tx_elevate', 'L2h0bWwvY29tX2NvbnRlbnQvYXJjaGl2ZS9kZWZhdWx0X2l0ZW1zLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('25', 'atom', 'L2h0bWwvY29tX2NvbnRlbnQvZmVhdHVyZWQvZGVmYXVsdC5waHA=', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('26', 'tx_elevate', 'L2h0bWwvY29tX2NvbnRlbnQvZmVhdHVyZWQvZGVmYXVsdC5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('27', 'atom', 'L2h0bWwvY29tX2NvbnRlbnQvZmVhdHVyZWQvZGVmYXVsdF9pdGVtLnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('28', 'tx_elevate', 'L2h0bWwvY29tX2NvbnRlbnQvZmVhdHVyZWQvZGVmYXVsdF9pdGVtLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('29', 'atom', 'L2h0bWwvY29tX2NvbnRlbnQvZmVhdHVyZWQvZGVmYXVsdF9saW5rcy5waHA=', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('30', 'tx_elevate', 'L2h0bWwvY29tX2NvbnRlbnQvZmVhdHVyZWQvZGVmYXVsdF9saW5rcy5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('31', 'atom', 'L2h0bWwvY29tX2ZpbmRlci9zZWFyY2gvZGVmYXVsdF9yZXN1bHQucGhw', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2024-04-29 09:09:23'),
('32', 'tx_elevate', 'L2h0bWwvY29tX2ZpbmRlci9zZWFyY2gvZGVmYXVsdF9yZXN1bHQucGhw', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2024-04-29 09:09:23'),
('33', 'atom', 'L2h0bWwvY29tX3RhZ3MvdGFnL2RlZmF1bHRfaXRlbXMucGhw', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('34', 'tx_elevate', 'L2h0bWwvY29tX3RhZ3MvdGFnL2RlZmF1bHRfaXRlbXMucGhw', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('35', 'atom', 'L2h0bWwvY29tX3RhZ3MvdGFncy9kZWZhdWx0X2l0ZW1zLnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('36', 'tx_elevate', 'L2h0bWwvY29tX3RhZ3MvdGFncy9kZWZhdWx0X2l0ZW1zLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('37', 'atom', 'L2h0bWwvY29tX3VzZXJzL3Byb2ZpbGUvZGVmYXVsdC5waHA=', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('38', 'tx_elevate', 'L2h0bWwvY29tX3VzZXJzL3Byb2ZpbGUvZGVmYXVsdC5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('39', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC90YWdzLnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('40', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC90YWdzLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('41', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9ibG9nX3N0eWxlX2RlZmF1bHRfaXRlbV90aXRsZS5waHA=', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('42', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9ibG9nX3N0eWxlX2RlZmF1bHRfaXRlbV90aXRsZS5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('43', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9mdWxsX2ltYWdlLnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('44', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9mdWxsX2ltYWdlLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('45', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL21vZGlmeV9kYXRlLnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('46', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL21vZGlmeV9kYXRlLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('47', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2F1dGhvci5waHA=', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('48', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2F1dGhvci5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('49', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2NhdGVnb3J5LnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('50', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2NhdGVnb3J5LnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('51', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2NyZWF0ZV9kYXRlLnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('52', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2NyZWF0ZV9kYXRlLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('53', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2hpdHMucGhw', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('54', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2hpdHMucGhw', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('55', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL3B1Ymxpc2hfZGF0ZS5waHA=', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('56', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL3B1Ymxpc2hfZGF0ZS5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('57', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL3BhcmVudF9jYXRlZ29yeS5waHA=', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('58', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL3BhcmVudF9jYXRlZ29yeS5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('59', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbnRyb19pbWFnZS5waHA=', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('60', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbnRyb19pbWFnZS5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('61', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZWRpdG9ycy9idXR0b25zL21vZGFsLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('62', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZWRpdG9ycy9idXR0b25zL2J1dHRvbi5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('63', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZWRpdG9ycy9idXR0b25zLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('64', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC91c2VyLnBocA==', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('65', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC91c2VyLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('66', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC9jb2xvci9hZHZhbmNlZC5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('67', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC9tZXRlci5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('68', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC9wYXNzd29yZC5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('69', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvbGlua3MvZ3JvdXBvcGVuLnBocA==', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('70', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvbGlua3MvbGluay5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('71', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvdG9vbGJhci92ZXJzaW9ucy5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2024-04-29 09:09:23'),
('72', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvdG9vbGJhci9iYXRjaC5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('73', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvdG9vbGJhci9wb3B1cC5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('74', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvdG9vbGJhci9zdGFuZGFyZC5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('75', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvdGlueW1jZS90ZXh0YXJlYS5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('76', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9saWJyYXJpZXMvaHRtbC9ib290c3RyYXAvbW9kYWwvbWFpbi5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('77', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9wbHVnaW5zL2VkaXRvcnMvdGlueW1jZS9maWVsZC90aW55bWNlYnVpbGRlci5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('78', 'atom', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdC5waHA=', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('79', 'tx_elevate', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdC5waHA=', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('80', 'atom', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdF91cmwucGhw', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('81', 'tx_elevate', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdF91cmwucGhw', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('82', 'atom', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdF9jb21wb25lbnQucGhw', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('83', 'tx_elevate', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdF9jb21wb25lbnQucGhw', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2023-11-07 04:24:40'),
('84', 'atom', 'L2h0bWwvbW9kX2JyZWFkY3J1bWJzL2RlZmF1bHQucGhw', '248', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2024-04-29 09:09:23'),
('85', 'tx_elevate', 'L2h0bWwvbW9kX2JyZWFkY3J1bWJzL2RlZmF1bHQucGhw', '261', '0', 'Joomla Update', '0', '2023-11-07 04:24:40', '2024-04-29 09:09:23'),
('86', 'atom', 'L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0X3Byb2ZpbGUucGhw', '248', '0', 'Joomla Update', '0', '2024-04-29 09:09:23', '2024-04-29 09:09:23'),
('87', 'atom', 'L2h0bWwvY29tX3RhZ3MvdGFnL2RlZmF1bHQucGhw', '248', '0', 'Joomla Update', '0', '2024-04-29 09:09:23', '2024-04-29 09:09:23'),
('88', 'tx_elevate', 'L2h0bWwvY29tX3RhZ3MvdGFnL2RlZmF1bHQucGhw', '261', '0', 'Joomla Update', '0', '2024-04-29 09:09:23', '2024-04-29 09:09:23'),
('89', 'atom', 'L2h0bWwvY29tX3RhZ3MvdGFnL2xpc3QucGhw', '248', '0', 'Joomla Update', '0', '2024-04-29 09:09:23', '2024-04-29 09:09:23'),
('90', 'tx_elevate', 'L2h0bWwvY29tX3RhZ3MvdGFnL2xpc3QucGhw', '261', '0', 'Joomla Update', '0', '2024-04-29 09:09:23', '2024-04-29 09:09:23'),
('91', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9vcHRpb25zX2RlZmF1bHQucGhw', '248', '0', 'Joomla Update', '0', '2024-04-29 09:09:23', '2024-04-29 09:09:23'),
('92', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9vcHRpb25zX2RlZmF1bHQucGhw', '261', '0', 'Joomla Update', '0', '2024-04-29 09:09:23', '2024-04-29 09:09:23'),
('93', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC9jb250ZW50aGlzdG9yeS5waHA=', '248', '0', 'Joomla Update', '0', '2024-04-29 09:09:23', '2024-04-29 09:09:23'),
('94', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC9jb250ZW50aGlzdG9yeS5waHA=', '261', '0', 'Joomla Update', '0', '2024-04-29 09:09:23', '2024-04-29 09:09:23'),
('95', 'atom', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC9tZWRpYS5waHA=', '248', '0', 'Joomla Update', '0', '2024-04-29 09:09:23', '2024-04-29 09:09:23'),
('96', 'tx_elevate', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC9tZWRpYS5waHA=', '261', '0', 'Joomla Update', '0', '2024-04-29 09:09:23', '2024-04-29 09:09:23');
/**ABDB**/CREATE TABLE `#__tags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The keywords for the page.',
  `metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int unsigned NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tags`  VALUES 
('1', '0', '0', '1', '0', '', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '', '', '', '', '376', '2023-08-20 07:05:33', '', '376', '2023-08-20 07:05:33', '', '', '0', '*', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__session` (
  `session_id` varbinary(192) NOT NULL,
  `client_id` tinyint unsigned DEFAULT NULL,
  `guest` tinyint unsigned DEFAULT '1',
  `time` int NOT NULL DEFAULT '0',
  `data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `userid` int DEFAULT '0',
  `username` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `userid` (`userid`),
  KEY `time` (`time`),
  KEY `client_id_guest` (`client_id`,`guest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__schemas` (
  `extension_id` int NOT NULL,
  `version_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__schemas`  VALUES 
('227', '5.1.0-2024-03-28'),
('236', '1.1'),
('298', '9.4.0-20221011');
/**ABDB**/CREATE TABLE `#__schemaorg` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `itemId` int unsigned DEFAULT NULL,
  `context` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schemaType` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schema` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__scheduler_tasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'unique identifier for job defined by plugin',
  `execution_rules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Execution Rules, Unprocessed',
  `cron_rules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Processed execution rules, crontab-like JSON form',
  `state` tinyint NOT NULL DEFAULT '0',
  `last_exit_code` int NOT NULL DEFAULT '0' COMMENT 'Exit code when job was last run',
  `last_execution` datetime DEFAULT NULL COMMENT 'Timestamp of last run',
  `next_execution` datetime DEFAULT NULL COMMENT 'Timestamp of next (planned) run, referred for execution on trigger',
  `times_executed` int DEFAULT '0' COMMENT 'Count of successful triggers',
  `times_failed` int DEFAULT '0' COMMENT 'Count of failures',
  `locked` datetime DEFAULT NULL,
  `priority` smallint NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0' COMMENT 'Configurable list ordering',
  `cli_exclusive` smallint NOT NULL DEFAULT '0' COMMENT 'If 1, the task is only accessible via CLI',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_state` (`state`),
  KEY `idx_last_exit` (`last_exit_code`),
  KEY `idx_next_exec` (`next_execution`),
  KEY `idx_locked` (`locked`),
  KEY `idx_priority` (`priority`),
  KEY `idx_cli_exclusive` (`cli_exclusive`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__scheduler_tasks`  VALUES 
('1', '139', 'Rotate Logs', 'rotation.logs', '{\"rule-type\":\"interval-days\",\"interval-days\":30,\"exec-time\":\"03:51\",\"exec-day\":\"07\"}', '{\"type\":\"interval\",\"exp\":\"P30D\"}', '1', '0', '2024-04-29 09:03:37', '2024-05-29 09:03:37', '1', '0', NULL, '0', '0', '0', '{\"logstokeep\":1}', NULL, '2023-11-07 04:24:37', '376', NULL, NULL),
('2', '140', 'Session GC', 'session.gc', '{\"rule-type\":\"interval-hours\",\"interval-hours\":24,\"exec-time\":\"04:24\",\"exec-day\":\"07\"}', '{\"type\":\"interval\",\"exp\":\"PT24H\"}', '1', '0', '2024-04-29 09:03:28', '2024-04-30 09:03:28', '1', '0', NULL, '0', '0', '0', '{\"enable_session_gc\":1,\"enable_session_metadata_gc\":1}', NULL, '2023-11-07 04:24:37', '376', NULL, NULL),
('3', '141', 'Update Notification', 'update.notification', '{\"rule-type\":\"interval-hours\",\"interval-hours\":6,\"exec-time\":\"03:51\",\"exec-day\":\"07\"}', '{\"type\":\"interval\",\"exp\":\"PT6H\"}', '1', '0', '2024-04-30 05:32:46', '2024-04-30 11:32:46', '2', '0', NULL, '0', '0', '0', '{\"email\":\"\",\"language_override\":\"\"}', NULL, '2023-11-07 04:24:37', '376', NULL, NULL);
/**ABDB**/CREATE TABLE `#__redirect_links` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `old_url` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_url` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int unsigned NOT NULL DEFAULT '0',
  `published` tinyint NOT NULL,
  `created_date` datetime NOT NULL,
  `modified_date` datetime NOT NULL,
  `header` smallint NOT NULL DEFAULT '301',
  PRIMARY KEY (`id`),
  KEY `idx_old_url` (`old_url`(100)),
  KEY `idx_link_modified` (`modified_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__quix_imgstats` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_id` int NOT NULL,
  `item_type` varchar(100) NOT NULL,
  `images_count` int NOT NULL,
  `original_size` int NOT NULL,
  `optimise_size` int NOT NULL,
  `mobile_size` int NOT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__quix_elements442` (
  `id` smallint NOT NULL AUTO_INCREMENT,
  `alias` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `params` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__quix_elements` (
  `id` smallint NOT NULL AUTO_INCREMENT,
  `alias` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `params` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__quix_editor_map` (
  `id` int NOT NULL AUTO_INCREMENT,
  `context` varchar(100) NOT NULL,
  `context_id` int NOT NULL,
  `collection_id` int NOT NULL,
  `status` tinyint NOT NULL DEFAULT '1',
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__quix_configs` (
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Store any configuration in key => params maps';
/**ABDB**/INSERT INTO `#__quix_configs`  VALUES 
('username', 'swopnil'),
('key', 'dfa41e2e70d48707bcbe1a33e47f7dcd'),
('activated', '1');
/**ABDB**/CREATE TABLE `#__quix_conditions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_id` int NOT NULL,
  `item_type` varchar(100) NOT NULL,
  `component` varchar(100) NOT NULL,
  `condition_type` varchar(100) NOT NULL COMMENT 'articles, categories, menus',
  `condition_id` int NOT NULL COMMENT 'type id',
  `condition_info` varchar(100) NOT NULL COMMENT 'type info direct to search',
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__quix_collections442` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `uid` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'section',
  `catid` int NOT NULL,
  `builder` enum('classic','frontend') NOT NULL DEFAULT 'classic',
  `builder_version` varchar(10) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `metadata` longtext NOT NULL,
  `language` varchar(5) NOT NULL,
  `ordering` int NOT NULL,
  `state` tinyint(1) NOT NULL,
  `access` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `params` longtext NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `hits` int NOT NULL,
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_catid` (`catid`),
  KEY `idx_state` (`state`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/**ABDB**/CREATE TABLE `#__quix_collections` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `uid` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `type` enum('layout','section','header','footer') NOT NULL DEFAULT 'section',
  `catid` int NOT NULL,
  `builder` enum('classic','frontend') NOT NULL DEFAULT 'classic',
  `builder_version` varchar(10) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `metadata` longtext NOT NULL,
  `language` varchar(5) NOT NULL,
  `ordering` int NOT NULL,
  `state` tinyint(1) NOT NULL,
  `access` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `params` longtext NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `hits` int NOT NULL,
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_catid` (`catid`),
  KEY `idx_state` (`state`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3;
/**ABDB**/INSERT INTO `#__quix_collections`  VALUES 
('1', '106', 'e6b0c64e82e01feca8a6c89c3a9d2447', 'startup-home', 'layout', '0', 'frontend', '4.4.2', '{\"type\":\"layout\",\"data\":[{\"children\":[{\"children\":[{\"children\":[{\"name\":\"Heading\",\"children\":[],\"slug\":\"heading\",\"form\":{\"general\":{\"heading_fields_group\":{\"title\":\"Need Business Consultation Today\",\"html_tag\":\"h1\"},\"heading_links_fields_group\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}}},\"styles\":{\"opt_fields_group\":{\"nalignment\":{\"desktop\":\"left\"},\"text_color\":\"#00194C\",\"text_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"heading_typo_fields_group\":{\"font\":{\"family\":\"Urbanist\",\"weight\":\"800\",\"size\":{\"desktop\":60},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.06},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"heading\",\"id\":\"qx-heading-ld0m9\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"name\":\"Text\",\"children\":[],\"slug\":\"text\",\"form\":{\"general\":{\"text_fields_group\":{\"content\":\"Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"}},\"styles\":{\"text_fields_group\":{\"alignment\":{\"tablet\":\"center\"},\"text_color\":\"#687799\"},\"typo_fields_group\":{\"font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"500\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"text\",\"id\":\"qx-text-5bvtm\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"name\":\"Dual Button\",\"children\":[],\"slug\":\"dual-button\",\"form\":{\"general\":{\"primary_button_fields_group\":{\"primary_text\":\"Discover More\",\"primary_link\":{\"url\":\"#\",\"target\":\"\",\"nofollow\":\"\"},\"primary_icon\":{\"source\":\"qxio-ios-arrow-thin-right\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"color\":\"rgba(255, 255, 255, 1)\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"primary_button_icon_alignment\":\"right\"},\"connector_button_fields_group\":{\"enable_connector\":false,\"connector_icon\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"secondary_button_fields_group\":{\"secondary_text\":\"Our Services\",\"secondary_link\":{\"url\":\"#\",\"target\":\"\",\"nofollow\":\"\"},\"secondary_icon\":{\"source\":\"qxio-ios-arrow-thin-right\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"color\":\"#00194C\"},\"type\":\"svg\",\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"secondary_button_icon_alignment\":\"right\"},\"layout_button_fields_group\":{\"button_layout_alignment\":{\"desktop\":\"left\"}}},\"styles\":{\"button_common_fields_group\":{\"btn_space\":{\"desktop\":15,\"tablet\":15},\"btn_padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":12,\"left\":30,\"bottom\":12,\"right\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"btn_typography\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"button_primary_fields_group\":{\"icon_primary_spacing\":{\"desktop\":5,\"tablet\":5,\"phone\":5,\"responsive_preview\":true,\"unit\":\"px\"},\"btn_primary_bg_color\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"#0055FF\"}},\"hover\":{\"properties\":{\"color\":\"#00194C\"}}}},\"btn_primary_typo\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"btn_primary_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":50,\"left\":50,\"bottom\":50,\"right\":50},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"button_connector_fields_group\":{\"btn_connector_width_height\":{\"desktop\":30,\"tablet\":30,\"phone\":30,\"responsive_preview\":true,\"unit\":\"px\"},\"btn_connector_typo\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"btn_connector_bg_color\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"btn_connector_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"button_secondary_fields_group\":{\"btn_secondary_text_color\":\"#00194C\",\"btn_secondary_text_hover_color\":\"rgba(255, 255, 255, 1)\",\"icon_secondary_spacing\":{\"desktop\":5,\"tablet\":5,\"phone\":5,\"responsive_preview\":true,\"unit\":\"px\"},\"icon_secondary_hover_color\":\"rgba(255, 255, 255, 1)\",\"btn_secondary_bg_color\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"rgba(0, 0, 0, 0)\"}},\"hover\":{\"properties\":{\"color\":\"#00194C\"}}}},\"btn_secondary_typo\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"btn_secondary_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":50,\"left\":50,\"bottom\":50,\"right\":50},\"border_width\":{\"top\":1,\"left\":1,\"bottom\":1,\"right\":1},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"#00194C\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"responsive_preview\":true,\"desktop\":{\"top\":35},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"dual-button\",\"id\":\"qx-dual-button-8b7qd\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":25}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-zxtww\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Image & Icon\",\"children\":[],\"slug\":\"image\",\"form\":{\"general\":{\"image_fields_group\":{\"image\":{\"source\":\"images\\/layout-pack\\/startup\\/hero_banner_img.jpeg\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"image_links_fields_group\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}}},\"styles\":{\"image_fields_group\":{\"alignment\":{\"tablet\":\"center\"},\"width\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"%\"}},\"border_fields_group\":{\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"icon_fields_group\":{\"icon_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"icon_background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"caption_field_group\":{\"caption_field_group_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"caption_field_group_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"caption_field_group_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"caption_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"image\",\"id\":\"qx-image-n2buj\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-d8tt6\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"row\",\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"qx-row-align-center\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"id\":\"qx-row-0e1g0\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"section\",\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":80,\"bottom\":80,\"left\":0,\"right\":0},\"phone\":{\"top\":20,\"bottom\":20,\"left\":0,\"right\":0},\"tablet\":{\"top\":40,\"bottom\":40,\"left\":0,\"right\":0}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"type\":\"gradient\",\"properties\":{\"color_1\":\"rgba(228, 207, 255, 0.08)\",\"color_2\":\"rgba(207, 240, 255, 0.3)\",\"type\":\"radial\",\"direction\":\"top right\",\"start_position\":68,\"end_position\":78}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"label\":\"Hero Area\",\"id\":\"qx-section-mr60g\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"children\":[{\"children\":[{\"name\":\"Heading\",\"children\":[],\"slug\":\"heading\",\"form\":{\"general\":{\"heading_fields_group\":{\"title\":\"Case Studies\"},\"heading_links_fields_group\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}}},\"styles\":{\"opt_fields_group\":{\"nalignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"},\"text_color\":\"#00194C\",\"text_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"heading_typo_fields_group\":{\"font\":{\"family\":\"Urbanist\",\"weight\":\"800\",\"size\":{\"desktop\":40},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.06},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"heading\",\"id\":\"qx-heading-3574p\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"name\":\"Text\",\"children\":[],\"slug\":\"text\",\"form\":{\"general\":{\"text_fields_group\":{\"content\":\"Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"}},\"styles\":{\"text_fields_group\":{\"alignment\":{\"desktop\":\"center\"},\"text_color\":\"#687799\"},\"typo_fields_group\":{\"font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"500\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"text\",\"id\":\"qx-text-6cqw1\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"left\":15,\"right\":15},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"%\"}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-6tolp\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"row\",\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"responsive_preview\":true,\"desktop\":{\"bottom\":60},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"id\":\"qx-row-6nboa\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"children\":[{\"name\":\"Blurb\",\"children\":[],\"slug\":\"blurb\",\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Web Design\",\"content\":\"Ceating brand identities, digital experiences, and print materials that communicate clearly.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"images\\/layout-pack\\/startup\\/webdesign.png\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"center\",\"img_position\":\"top\",\"img_content_v_align\":\"qx-align-items-center\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":25},\"image_width\":{\"desktop\":55,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"title_color\":\"#00194C\",\"title_font\":{\"family\":\"Urbanist\",\"weight\":\"700\",\"size\":{\"desktop\":20},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"#687799\",\"body_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"responsive_preview\":true,\"desktop\":{\"bottom\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":45,\"left\":30,\"bottom\":45,\"right\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"rgba(255, 255, 255, 1)\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":10,\"left\":10,\"bottom\":10,\"right\":10},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(210, 210, 234, .4)\",\"blur\":60,\"horizontal\":-5,\"vertical\":18}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"blurb\",\"id\":\"qx-blurb-n8k9g\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-hdkcr\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Blurb\",\"children\":[],\"slug\":\"blurb\",\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Digital Marketing\",\"content\":\"Ceating brand identities, digital experiences, and print materials that communicate clearly.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"images\\/layout-pack\\/startup\\/digitalMarketing.png\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"center\",\"img_position\":\"top\",\"img_content_v_align\":\"qx-align-items-center\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":25},\"image_width\":{\"desktop\":55,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"title_color\":\"#00194C\",\"title_font\":{\"family\":\"Urbanist\",\"weight\":\"700\",\"size\":{\"desktop\":20},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"#687799\",\"body_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"responsive_preview\":true,\"desktop\":{\"top\":60,\"bottom\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":45,\"left\":30,\"bottom\":45,\"right\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"rgba(255, 255, 255, 1)\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":10,\"left\":10,\"bottom\":10,\"right\":10},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(210, 210, 234, .4)\",\"blur\":60,\"horizontal\":-5,\"vertical\":18}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"blurb\",\"id\":\"qx-blurb-je545\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-pwloj\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Blurb\",\"children\":[],\"slug\":\"blurb\",\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Search Engine Optimization\",\"content\":\"Ceating brand identities, digital experiences, and print materials that communicate clearly.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"images\\/layout-pack\\/startup\\/seo.png\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"center\",\"img_position\":\"top\",\"img_content_v_align\":\"qx-align-items-center\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":25},\"image_width\":{\"desktop\":55,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"title_color\":\"#00194C\",\"title_font\":{\"family\":\"Urbanist\",\"weight\":\"700\",\"size\":{\"desktop\":20},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"#687799\",\"body_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"responsive_preview\":true,\"desktop\":{\"bottom\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":45,\"left\":30,\"bottom\":45,\"right\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"rgba(255, 255, 255, 1)\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":10,\"left\":10,\"bottom\":10,\"right\":10},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(210, 210, 234, .4)\",\"blur\":60,\"horizontal\":-5,\"vertical\":18}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"blurb\",\"id\":\"qx-blurb-a73tq\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-8nl2f\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Blurb\",\"children\":[],\"slug\":\"blurb\",\"form\":{\"general\":{\"blurb_fg_text\":{\"title\":\"Social Media\",\"content\":\"Ceating brand identities, digital experiences, and print materials that communicate clearly.\"},\"blurb_fg_links\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"blurb_fg_image\":{\"image\":{\"source\":\"images\\/layout-pack\\/startup\\/social.png\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"blurb_fg_layout\":{\"img_alignment\":\"center\",\"img_position\":\"top\",\"img_content_v_align\":\"qx-align-items-center\"}},\"styles\":{\"blurb_fg_image_style\":{\"image_spacing\":{\"desktop\":25},\"image_width\":{\"desktop\":55,\"unit\":\"px\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"blurb_fg_content\":{\"content_alignment\":{\"desktop\":\"\",\"tablet\":\"\",\"phone\":\"\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"blurb_fg_title\":{\"title_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"title_color\":\"#00194C\",\"title_font\":{\"family\":\"Urbanist\",\"weight\":\"700\",\"size\":{\"desktop\":20},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"blurb_fg_body\":{\"body_color\":\"#687799\",\"body_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"responsive_preview\":true,\"desktop\":{\"top\":60,\"bottom\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":45,\"left\":30,\"bottom\":45,\"right\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"rgba(255, 255, 255, 1)\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":10,\"left\":10,\"bottom\":10,\"right\":10},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(210, 210, 234, .4)\",\"blur\":60,\"horizontal\":-5,\"vertical\":18}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"blurb\",\"id\":\"qx-blurb-22od1\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-rv2b0\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"row\",\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"id\":\"qx-row-tmieo\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"section\",\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":80,\"bottom\":80,\"left\":0,\"right\":0},\"phone\":{\"top\":20,\"bottom\":20,\"left\":0,\"right\":0},\"tablet\":{\"top\":40,\"bottom\":40,\"left\":0,\"right\":0}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"type\":\"gradient\",\"properties\":{\"color_1\":\"rgba(250, 232, 255, 0.09)\",\"color_2\":\"rgba(207, 240, 255, 0.08)\",\"direction\":180}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"id\":\"qx-section-3v5ce\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"children\":[{\"children\":[{\"name\":\"Image & Icon\",\"children\":[],\"slug\":\"image\",\"form\":{\"general\":{\"image_fields_group\":{\"image\":{\"source\":\"images\\/layout-pack\\/startup\\/about_img01.png\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"image_links_fields_group\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}}},\"styles\":{\"image_fields_group\":{\"alignment\":{\"desktop\":\"center\"},\"width\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"%\"}},\"border_fields_group\":{\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"icon_fields_group\":{\"icon_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"icon_background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"caption_field_group\":{\"caption_field_group_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"caption_field_group_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"caption_field_group_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"caption_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"src\":{\"type\":\"image\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"source\":\"\",\"dimension\":{\"width\":\"\",\"height\":\"\"},\"properties\":{\"color\":\"rgba(0, 0, 0, 1)\",\"size\":30}},\"parallax\":false}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"image\",\"id\":\"qx-image-xii5e\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"src\":{\"type\":\"image\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"source\":\"images\\/layout-pack\\/startup\\/about_img_shape01.png\",\"dimension\":{\"width\":\"\",\"height\":\"\"},\"properties\":{\"color\":\"rgba(0, 0, 0, 1)\",\"size\":30}},\"size\":\"initial\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-pntfb\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Heading\",\"children\":[],\"slug\":\"heading\",\"form\":{\"general\":{\"heading_fields_group\":{\"title\":\"Changing The Way To Do Best Business Solutions\"},\"heading_links_fields_group\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}}},\"styles\":{\"opt_fields_group\":{\"nalignment\":{\"desktop\":\"left\"},\"text_color\":\"#00194C\",\"text_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"heading_typo_fields_group\":{\"font\":{\"family\":\"Urbanist\",\"weight\":\"800\",\"size\":{\"desktop\":40},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.06},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"heading\",\"id\":\"qx-heading-tdumy\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"name\":\"Text\",\"children\":[],\"slug\":\"text\",\"form\":{\"general\":{\"text_fields_group\":{\"content\":\"Borem ipsum dolor sit amet, consectetur adipiscing elita floraipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod temporincididunt ut labore et dolore magna aliqua Quis suspendisse ultri ces gravida.\"}},\"styles\":{\"text_fields_group\":{\"alignment\":{\"desktop\":\"left\",\"tablet\":\"center\"},\"text_color\":\"#687799\"},\"typo_fields_group\":{\"font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"500\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"text\",\"id\":\"qx-text-tlqrg\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-k1av5\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"row\",\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"qx-row-align-center\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"responsive_preview\":true,\"desktop\":{\"bottom\":60},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"id\":\"qx-row-o8gg2\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"section\",\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":80,\"bottom\":80,\"left\":0,\"right\":0},\"phone\":{\"top\":20,\"bottom\":20,\"left\":0,\"right\":0},\"tablet\":{\"top\":40,\"bottom\":40,\"left\":0,\"right\":0}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"src\":{\"type\":\"image\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"source\":\"images\\/layout-pack\\/startup\\/about_bg.jpeg\",\"dimension\":{\"width\":\"\",\"height\":\"\"},\"properties\":{\"color\":\"rgba(0, 0, 0, 1)\",\"size\":30}}}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"id\":\"qx-section-xr0hb\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"children\":[{\"children\":[{\"name\":\"Heading\",\"children\":[],\"slug\":\"heading\",\"form\":{\"general\":{\"heading_fields_group\":{\"title\":\"The hundred of completed works still counting\"},\"heading_links_fields_group\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}}},\"styles\":{\"opt_fields_group\":{\"nalignment\":{\"desktop\":\"left\"},\"text_color\":\"#00194C\",\"text_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"heading_typo_fields_group\":{\"font\":{\"family\":\"Urbanist\",\"weight\":\"800\",\"size\":{\"desktop\":40},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.06},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"heading\",\"id\":\"qx-heading-6gthg\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"name\":\"Text\",\"children\":[],\"slug\":\"text\",\"form\":{\"general\":{\"text_fields_group\":{\"content\":\"Borem ipsum dolor sit amet, consectetur adipiscing elita floraipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod temporincididunt ut labore et dolore magna aliqua Quis suspendisse ultri ces gravida.\"}},\"styles\":{\"text_fields_group\":{\"alignment\":{\"desktop\":\"left\",\"tablet\":\"center\"},\"text_color\":\"#687799\"},\"typo_fields_group\":{\"font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"500\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"text\",\"id\":\"qx-text-n9fep\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"right\":10},\"tablet\":{\"left\":10},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"%\"}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-syv6u\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Columns\",\"children\":[{\"children\":[{\"children\":[{\"name\":\"Counter\",\"children\":[],\"slug\":\"counter\",\"form\":{\"general\":{\"counter_fg_element_mode\":{\"count_end\":\"19\",\"counter_prefix\":null,\"suffix\":\"+\",\"title\":\"Total Top Services\",\"alignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"}}},\"styles\":{\"counter_fg_number_style\":{\"number_color\":\"#00194C\",\"number_typo\":{\"family\":\"Urbanist\",\"weight\":\"700\",\"size\":{\"desktop\":35},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.6},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"number_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"counter_fg_title_style\":{\"title_color\":\"#687799\",\"title_typo\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"title_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"rgba(255, 255, 255, 1)\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"counter\",\"id\":\"qx-counter-7b9g5\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-k5ies\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Counter\",\"children\":[],\"slug\":\"counter\",\"form\":{\"general\":{\"counter_fg_element_mode\":{\"count_end\":\"25\",\"counter_prefix\":null,\"suffix\":\"+\",\"title\":\"Countries\",\"alignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"}}},\"styles\":{\"counter_fg_number_style\":{\"number_color\":\"#00194C\",\"number_typo\":{\"family\":\"Urbanist\",\"weight\":\"700\",\"size\":{\"desktop\":35},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.6},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"number_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"counter_fg_title_style\":{\"title_color\":\"#687799\",\"title_typo\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"title_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"rgba(255, 255, 255, 1)\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"counter\",\"id\":\"qx-counter-z8gc1\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-7iusl\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"row\",\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"id\":\"qx-row-xkitv\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"children\":[{\"name\":\"Counter\",\"children\":[],\"slug\":\"counter\",\"form\":{\"general\":{\"counter_fg_element_mode\":{\"count_end\":\"98\",\"counter_prefix\":null,\"suffix\":\"+\",\"title\":\"Positive Feedback\",\"alignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"}}},\"styles\":{\"counter_fg_number_style\":{\"number_color\":\"#00194C\",\"number_typo\":{\"family\":\"Urbanist\",\"weight\":\"700\",\"size\":{\"desktop\":35},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.6},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"number_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"counter_fg_title_style\":{\"title_color\":\"#687799\",\"title_typo\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"title_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"rgba(255, 255, 255, 1)\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"counter\",\"id\":\"qx-counter-g2es6\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-khm6y\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Counter\",\"children\":[],\"slug\":\"counter\",\"form\":{\"general\":{\"counter_fg_element_mode\":{\"count_end\":\"36459\",\"counter_prefix\":null,\"suffix\":\"+\",\"title\":\"Usual Users\",\"alignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"}}},\"styles\":{\"counter_fg_number_style\":{\"number_color\":\"#00194C\",\"number_typo\":{\"family\":\"Urbanist\",\"weight\":\"700\",\"size\":{\"desktop\":35},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.6},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"number_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"counter_fg_title_style\":{\"title_color\":\"#687799\",\"title_typo\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"title_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"rgba(255, 255, 255, 1)\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"counter\",\"id\":\"qx-counter-msavk\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-cjofr\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"row\",\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"id\":\"qx-row-k3dwl\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"%\"},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"column\",\"id\":\"qx-column-gyuu0\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"responsive_preview\":true,\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"rgba(255, 255, 255, 1)\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":10,\"left\":10,\"bottom\":10,\"right\":10},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(22, 17, 147, 0.1)\",\"blur\":90,\"vertical\":50}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-78pfo\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"row\",\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"qx-row-align-center\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"responsive_preview\":true,\"desktop\":{\"bottom\":60},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"id\":\"qx-row-28x95\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"section\",\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":80,\"bottom\":80,\"left\":0,\"right\":0},\"phone\":{\"top\":20,\"bottom\":20,\"left\":0,\"right\":0},\"tablet\":{\"top\":40,\"bottom\":40,\"left\":0,\"right\":0}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"required_parallax\":true,\"parallax\":true}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"id\":\"qx-section-zrl0e\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"children\":[{\"children\":[{\"name\":\"Image & Icon\",\"children\":[],\"slug\":\"image\",\"form\":{\"general\":{\"image_fields_group\":{\"image\":{\"source\":\"images\\/layout-pack\\/startup\\/testimonial_img.png\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"image_links_fields_group\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}}},\"styles\":{\"image_fields_group\":{\"alignment\":{\"desktop\":\"center\"},\"width\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"%\"}},\"border_fields_group\":{\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"icon_fields_group\":{\"icon_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"icon_background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"caption_field_group\":{\"caption_field_group_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"caption_field_group_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"caption_field_group_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"caption_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"src\":{\"type\":\"image\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"source\":\"\",\"dimension\":{\"width\":\"\",\"height\":\"\"},\"properties\":{\"color\":\"rgba(0, 0, 0, 1)\",\"size\":30}}}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"image\",\"id\":\"qx-image-gja31\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"right\":10},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"%\"}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"src\":{\"type\":\"image\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"source\":\"images\\/layout-pack\\/startup\\/testimonial_shape01.png\",\"dimension\":{\"width\":\"\",\"height\":\"\"},\"properties\":{\"color\":\"rgba(0, 0, 0, 1)\",\"size\":30}},\"size\":\"initial\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-2aomh\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Heading\",\"children\":[],\"slug\":\"heading\",\"form\":{\"general\":{\"heading_fields_group\":{\"title\":\"What our awesome customers say\"},\"heading_links_fields_group\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}}},\"styles\":{\"opt_fields_group\":{\"nalignment\":{\"desktop\":\"left\"},\"text_color\":\"#00194C\",\"text_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"heading_typo_fields_group\":{\"font\":{\"family\":\"Urbanist\",\"weight\":\"800\",\"size\":{\"desktop\":40},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.06},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"heading\",\"id\":\"qx-heading-hvuxu\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"name\":\"Testimonial Carousel\",\"children\":[],\"slug\":\"testimonial-carousel\",\"form\":{\"general\":{\"testimonial-carousel_fg_repeater\":[{\"tname\":\"Robert Fox\",\"content\":\"Morem ipsum dolor sit amet, consectetur adipiscing elita florai sum dolor sit amet, consecteture.Borem ipsum dolor sit amet, consectetur.\",\"position\":\"CEO, Digital Agency\",\"rating\":true,\"set_rating\":4,\"image\":{\"type\":\"image\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"source\":\"images\\/layout-pack\\/startup\\/testi_avatar01.png\",\"dimension\":{\"width\":\"\",\"height\":\"\"},\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"}}},{\"tname\":\"Mr.Robey Alexa\",\"content\":\"Morem ipsum dolor sit amet, consectetur adipiscing elita florai sum dolor sit amet, consecteture.Borem ipsum dolor sit amet, consectetur.\",\"position\":\"CEO, Digital Agency\",\"rating\":true,\"set_rating\":3,\"image\":{\"type\":\"image\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"source\":\"images\\/layout-pack\\/startup\\/testi_avatar02.png\",\"dimension\":{\"width\":\"\",\"height\":\"\"},\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"}},\"title\":\"undefined (copy)\"}],\"testimonial-carousel_fg_layouts\":{\"layout_grid\":{\"desktop\":\"qx-child-width-1-1\",\"tablet\":\"qx-child-width-1-1\",\"phone\":\"qx-child-width-1-1\"},\"enable_quote\":false},\"testimonial-carousel_fg_navigation\":{\"show_arrow_navigation\":false,\"show_dot_navigation\":false},\"testimonial-carousel_fg_behaviour\":{\"faqpage\":false,\"pause_on_hover\":true,\"auto_play\":true,\"autoplay_speed\":5000,\"infinite_loop\":false}},\"styles\":{\"testimonial-carousel_fg_testimonial\":{\"content_alignment\":{\"desktop\":\"left\"},\"item_gutter\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"testi_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"testi_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"testi_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"slider_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"testimonial-carousel_fg_image\":{\"width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"},\"image_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":15,\"responsive_preview\":true,\"unit\":\"px\"},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"testimonial-carousel_fg_quote\":{\"quote_size\":{\"desktop\":35,\"tablet\":35,\"phone\":35,\"responsive_preview\":true,\"unit\":\"px\"},\"quote_gap\":{\"desktop\":15,\"tablet\":15,\"phone\":15,\"responsive_preview\":true,\"unit\":\"px\"}},\"testimonial-carousel_fg_name\":{\"name_spacing\":{\"desktop\":5,\"tablet\":5,\"phone\":5,\"responsive_preview\":true,\"unit\":\"px\"},\"name_color\":\"#00194C\",\"name_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"700\",\"size\":{\"desktop\":20},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"testimonial-carousel_fg_position\":{\"position_spacing\":{\"desktop\":5,\"tablet\":5,\"phone\":5,\"responsive_preview\":true,\"unit\":\"px\"},\"position_color\":\"#687799\",\"position_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"testimonial-carousel_fg_content\":{\"content_color\":\"#687799\",\"content_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":15,\"responsive_preview\":true,\"unit\":\"px\"},\"content_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":18},\"style\":\"italic\",\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.6},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"testimonial-carousel_fg_navigation_style\":{\"arrow_size\":{\"desktop\":25,\"tablet\":25,\"phone\":20,\"responsive_preview\":true,\"unit\":\"px\"},\"arrow_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"arrow_bd\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}},\"arrow_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":15,\"right\":15},\"phone\":{\"top\":15,\"bottom\":15,\"left\":15,\"right\":15},\"tablet\":{\"top\":15,\"bottom\":15,\"left\":15,\"right\":15}},\"dot_width\":{\"desktop\":15,\"tablet\":15,\"phone\":15,\"responsive_preview\":true,\"unit\":\"px\"},\"dot_spacing\":{\"desktop\":12,\"tablet\":12,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"dot_margin\":{\"desktop\":25,\"tablet\":25,\"phone\":20,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"testimonial-carousel\",\"id\":\"qx-testimonial-carousel-eyq3f\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":50,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":40}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"right\":10},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"%\"}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-73dbz\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"row\",\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":\"qx-row-align-center\"}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"responsive_preview\":true,\"desktop\":{\"bottom\":60},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"id\":\"qx-row-rwsk0\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"section\",\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":80,\"bottom\":80,\"left\":0,\"right\":0},\"phone\":{\"top\":20,\"bottom\":20,\"left\":0,\"right\":0},\"tablet\":{\"top\":40,\"bottom\":40,\"left\":0,\"right\":0}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"required_parallax\":true,\"parallax\":true}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"id\":\"qx-section-ikkv4\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"children\":[{\"children\":[{\"name\":\"Heading\",\"children\":[],\"slug\":\"heading\",\"form\":{\"general\":{\"heading_fields_group\":{\"title\":\"Simple pricing solutions for everyone\"},\"heading_links_fields_group\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}}},\"styles\":{\"opt_fields_group\":{\"nalignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"},\"text_color\":\"#00194C\",\"text_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"heading_typo_fields_group\":{\"font\":{\"family\":\"Urbanist\",\"weight\":\"800\",\"size\":{\"desktop\":40},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.06},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"heading\",\"id\":\"qx-heading-ul0ew\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"name\":\"Text\",\"children\":[],\"slug\":\"text\",\"form\":{\"general\":{\"text_fields_group\":{\"content\":\"Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"}},\"styles\":{\"text_fields_group\":{\"alignment\":{\"desktop\":\"center\"},\"text_color\":\"#687799\"},\"typo_fields_group\":{\"font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"500\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"text\",\"id\":\"qx-text-0el2u\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"left\":15,\"right\":15},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"%\"}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-zryk5\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"row\",\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"responsive_preview\":true,\"desktop\":{\"bottom\":60},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"id\":\"qx-row-v2j76\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"children\":[{\"name\":\"Pricing Table\",\"children\":[],\"slug\":\"pricing-table\",\"form\":{\"general\":{\"features\":[{\"title\":\"300 GB Storage\",\"tooltip\":\"\",\"icon\":{\"source\":null,\"base_domain\":\"\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Unlimited Photos and Videos\",\"tooltip\":\"\",\"icon\":{\"source\":null,\"base_domain\":\"\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Pricing Feature Three\",\"tooltip\":\"\",\"icon\":{\"source\":null,\"base_domain\":\"\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Pricing Feature Four\",\"tooltip\":\"\",\"icon\":{\"source\":null,\"base_domain\":\"\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}}],\"pricing_header\":{\"price\":\"39\",\"duration\":\"Yearly\",\"image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"pricing_footer\":{\"button\":\"Join This Plan\",\"link\":{\"url\":\"#\",\"target\":\"\",\"nofollow\":false}},\"pricing_badge\":{\"enable_badge\":false,\"pricing_badge_title\":\"Recommended\",\"badge_alignment\":\"left\",\"tooltip_alignment\":\"right\"}},\"styles\":{\"pricing_style\":{\"content_alignment\":{\"desktop\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":2.5,\"bottom\":2.5,\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":35,\"bottom\":50,\"left\":20,\"right\":20},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"responsive_preview\":true,\"unit\":\"em\"}},\"header_style\":{\"header_padding\":{\"responsive_preview\":true,\"desktop\":{\"bottom\":0.5},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"em\"},\"header_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"header_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":1,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"#e8e8e8\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_title_style\":{\"title_color\":\"#687799\",\"title_spacing\":{\"desktop\":0},\"title_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"title_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"700\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"pricing_price_style\":{\"price_color\":\"#00194C\",\"price_spacing\":{\"desktop\":0},\"price_font\":{\"family\":\"Urbanist\",\"weight\":\"800\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"old_price_fs\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"currency_color\":\"#687799\",\"currency_fs\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"duration_color\":\"#687799\",\"duration_fs\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"}},\"pricing_image_style\":{\"image_spacing\":{\"desktop\":30,\"tablet\":30,\"phone\":20,\"responsive_preview\":true,\"unit\":\"px\"},\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_features_style\":{\"feature_spacing\":{\"desktop\":5,\"tablet\":5,\"phone\":5,\"responsive_preview\":true,\"unit\":\"px\"},\"feature_item_padding\":{\"desktop\":{\"top\":5,\"bottom\":20,\"left\":0,\"right\":0},\"phone\":{\"top\":0,\"bottom\":15,\"left\":0,\"right\":0},\"tablet\":{\"top\":0,\"bottom\":15,\"left\":0,\"right\":0}},\"feature_icon_space\":{\"desktop\":5,\"tablet\":5,\"phone\":5,\"responsive_preview\":true,\"unit\":\"px\"},\"features_color\":\"#687799\",\"features_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"features_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_badge_style\":{\"badge_padding\":{\"desktop\":{\"top\":12,\"bottom\":12,\"left\":50,\"right\":50},\"phone\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":35,\"right\":35}},\"badge_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"badge_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"badge_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"badge_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_button_style\":{\"button_text_color\":\"#00194C\",\"button_hover_text_color\":\"rgba(255, 255, 255, 1)\",\"button_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":45,\"right\":45},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30}},\"button_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"button_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_bg\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"rgba(0, 0, 0, 0)\"}},\"hover\":{\"properties\":{\"color\":\"#00194C\"}}}},\"btn_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":50,\"left\":50,\"bottom\":50,\"right\":50},\"border_width\":{\"top\":1,\"left\":1,\"bottom\":1,\"right\":1},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"#00194C\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(0, 0, 0, .05)\",\"blur\":40,\"vertical\":20}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"pricing-table\",\"id\":\"qx-pricing-table-h2grq\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":33.33333,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-uihvi\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Pricing Table\",\"children\":[],\"slug\":\"pricing-table\",\"form\":{\"general\":{\"features\":[{\"title\":\"500 GB Storage\",\"tooltip\":\"\",\"icon\":{\"source\":null,\"base_domain\":\"\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Unlimited Photos and Videos\",\"tooltip\":\"\",\"icon\":{\"source\":null,\"base_domain\":\"\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Pricing Feature Three\",\"tooltip\":\"\",\"icon\":{\"source\":null,\"base_domain\":\"\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Pricing Feature Four\",\"tooltip\":\"\",\"icon\":{\"source\":null,\"base_domain\":\"\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}}],\"pricing_header\":{\"header_title\":\"Popular\",\"price\":\"54\",\"duration\":\"Yearly\",\"image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"pricing_footer\":{\"button\":\"Join This Plan\",\"link\":{\"url\":\"#\",\"target\":\"\",\"nofollow\":false}},\"pricing_badge\":{\"enable_badge\":true,\"pricing_badge_title\":\"Best Sell\",\"badge_alignment\":\"rotateleft\"}},\"styles\":{\"pricing_style\":{\"content_alignment\":{\"desktop\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":2.5,\"bottom\":2.5,\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":35,\"bottom\":50,\"left\":20,\"right\":20},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"responsive_preview\":true,\"unit\":\"em\"}},\"header_style\":{\"header_padding\":{\"responsive_preview\":true,\"desktop\":{\"bottom\":0.5},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"em\"},\"header_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"header_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":1,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"#e8e8e8\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_title_style\":{\"title_color\":\"#00194C\",\"title_spacing\":{\"desktop\":0},\"title_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"title_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"700\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"pricing_price_style\":{\"price_color\":\"#00194C\",\"price_spacing\":{\"desktop\":0},\"price_font\":{\"family\":\"Urbanist\",\"weight\":\"800\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"old_price_fs\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"currency_color\":\"#687799\",\"currency_fs\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"duration_color\":\"#687799\",\"duration_fs\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"}},\"pricing_image_style\":{\"image_spacing\":{\"desktop\":30,\"tablet\":30,\"phone\":20,\"responsive_preview\":true,\"unit\":\"px\"},\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_features_style\":{\"feature_spacing\":{\"desktop\":5,\"tablet\":5,\"phone\":5,\"responsive_preview\":true,\"unit\":\"px\"},\"feature_item_padding\":{\"desktop\":{\"top\":5,\"bottom\":20,\"left\":0,\"right\":0},\"phone\":{\"top\":0,\"bottom\":15,\"left\":0,\"right\":0},\"tablet\":{\"top\":0,\"bottom\":15,\"left\":0,\"right\":0}},\"feature_icon_space\":{\"desktop\":5,\"tablet\":5,\"phone\":5,\"responsive_preview\":true,\"unit\":\"px\"},\"features_color\":\"#687799\",\"features_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"features_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_badge_style\":{\"badge_padding\":{\"desktop\":{\"top\":10,\"bottom\":10,\"left\":35},\"phone\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":35,\"right\":35},\"responsive_preview\":true},\"badge_margin\":{\"responsive_preview\":true,\"desktop\":{\"top\":-20,\"left\":35},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"badge_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"badge_bg\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"#00194C\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"badge_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_button_style\":{\"button_text_color\":\"rgba(255, 255, 255, 1)\",\"button_hover_text_color\":\"#00194C\",\"button_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":45,\"right\":45},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30}},\"button_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"button_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_bg\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"#00194C\"}},\"hover\":{\"properties\":{\"color\":\"rgba(0, 25, 77, 0)\"}}}},\"btn_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":50,\"left\":50,\"bottom\":50,\"right\":50},\"border_width\":{\"top\":1,\"left\":1,\"bottom\":1,\"right\":1},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"#00194C\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(0, 0, 0, .05)\",\"blur\":40,\"vertical\":20}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"pricing-table\",\"id\":\"qx-pricing-table-eguyt\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":33.33333,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-kyb3u\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Pricing Table\",\"children\":[],\"slug\":\"pricing-table\",\"form\":{\"general\":{\"features\":[{\"title\":\"700 GB Storage\",\"tooltip\":\"\",\"icon\":{\"source\":null,\"base_domain\":\"\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Unlimited Photos and Videos\",\"tooltip\":\"\",\"icon\":{\"source\":null,\"base_domain\":\"\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Pricing Feature Three\",\"tooltip\":\"\",\"icon\":{\"source\":null,\"base_domain\":\"\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}},{\"title\":\"Pricing Feature Four\",\"tooltip\":\"\",\"icon\":{\"source\":null,\"base_domain\":\"\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"type\":\"image\",\"dimension\":{\"width\":\"\",\"height\":\"\"}}}],\"pricing_header\":{\"header_title\":\"Exclusive\",\"price\":\"82\",\"duration\":\"Yearly\",\"image\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"pricing_footer\":{\"button\":\"Join This Plan\",\"link\":{\"url\":\"#\",\"target\":\"\",\"nofollow\":false}},\"pricing_badge\":{\"enable_badge\":false,\"pricing_badge_title\":\"Recommended\",\"badge_alignment\":\"left\",\"tooltip_alignment\":\"right\"}},\"styles\":{\"pricing_style\":{\"content_alignment\":{\"desktop\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":2.5,\"bottom\":2.5,\"left\":\"\",\"right\":\"\"},\"phone\":{\"top\":35,\"bottom\":50,\"left\":20,\"right\":20},\"tablet\":{\"top\":\"\",\"bottom\":\"\",\"left\":\"\",\"right\":\"\"},\"responsive_preview\":true,\"unit\":\"em\"}},\"header_style\":{\"header_padding\":{\"responsive_preview\":true,\"desktop\":{\"bottom\":0.5},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"em\"},\"header_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"header_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":0,\"left\":0,\"bottom\":1,\"right\":0},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"#e8e8e8\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_title_style\":{\"title_color\":\"#687799\",\"title_spacing\":{\"desktop\":0},\"title_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"title_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"700\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"pricing_price_style\":{\"price_color\":\"#00194C\",\"price_spacing\":{\"desktop\":0},\"price_font\":{\"family\":\"Urbanist\",\"weight\":\"800\",\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"old_price_fs\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"currency_color\":\"#687799\",\"currency_fs\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"duration_color\":\"#687799\",\"duration_fs\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"}},\"pricing_image_style\":{\"image_spacing\":{\"desktop\":30,\"tablet\":30,\"phone\":20,\"responsive_preview\":true,\"unit\":\"px\"},\"image_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"image_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"image_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"image_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_features_style\":{\"feature_spacing\":{\"desktop\":5,\"tablet\":5,\"phone\":5,\"responsive_preview\":true,\"unit\":\"px\"},\"feature_item_padding\":{\"desktop\":{\"top\":5,\"bottom\":20,\"left\":0,\"right\":0},\"phone\":{\"top\":0,\"bottom\":15,\"left\":0,\"right\":0},\"tablet\":{\"top\":0,\"bottom\":15,\"left\":0,\"right\":0}},\"feature_icon_space\":{\"desktop\":5,\"tablet\":5,\"phone\":5,\"responsive_preview\":true,\"unit\":\"px\"},\"features_color\":\"#687799\",\"features_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"features_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_badge_style\":{\"badge_padding\":{\"desktop\":{\"top\":12,\"bottom\":12,\"left\":50,\"right\":50},\"phone\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":35,\"right\":35}},\"badge_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"badge_font\":{\"size\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"badge_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"badge_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"pricing_button_style\":{\"button_text_color\":\"#00194C\",\"button_hover_text_color\":\"rgba(255, 255, 255, 1)\",\"button_padding\":{\"desktop\":{\"top\":15,\"bottom\":15,\"left\":45,\"right\":45},\"phone\":{\"top\":10,\"bottom\":10,\"left\":25,\"right\":25},\"tablet\":{\"top\":10,\"bottom\":10,\"left\":30,\"right\":30}},\"button_margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"button_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}},\"button_bg\":{\"state\":{\"normal\":{\"properties\":{\"color\":\"rgba(0, 0, 0, 0)\"}},\"hover\":{\"properties\":{\"color\":\"#00194C\"}}}},\"btn_border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":50,\"left\":50,\"bottom\":50,\"right\":50},\"border_width\":{\"top\":1,\"left\":1,\"bottom\":1,\"right\":1},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"#00194C\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"rgba(0, 0, 0, .05)\",\"blur\":40,\"vertical\":20}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"pricing-table\",\"id\":\"qx-pricing-table-tpuit\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":33.33333,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-3lnsf\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"row\",\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"id\":\"qx-row-tlylt\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"section\",\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":80,\"bottom\":80,\"left\":0,\"right\":0},\"phone\":{\"top\":20,\"bottom\":20,\"left\":0,\"right\":0},\"tablet\":{\"top\":40,\"bottom\":40,\"left\":0,\"right\":0}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"required_parallax\":true,\"parallax\":true}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"id\":\"qx-section-p2y5g\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"children\":[{\"children\":[{\"name\":\"Heading\",\"children\":[],\"slug\":\"heading\",\"form\":{\"general\":{\"heading_fields_group\":{\"title\":\"Experience Team Members\"},\"heading_links_fields_group\":{\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}}},\"styles\":{\"opt_fields_group\":{\"nalignment\":{\"desktop\":\"center\",\"tablet\":\"center\",\"phone\":\"center\"},\"text_color\":\"#00194C\",\"text_bg\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"heading_typo_fields_group\":{\"font\":{\"family\":\"Urbanist\",\"weight\":\"800\",\"size\":{\"desktop\":40},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.06},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"heading\",\"id\":\"qx-heading-ezve4\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"name\":\"Text\",\"children\":[],\"slug\":\"text\",\"form\":{\"general\":{\"text_fields_group\":{\"content\":\"Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\"}},\"styles\":{\"text_fields_group\":{\"alignment\":{\"desktop\":\"center\"},\"text_color\":\"#687799\"},\"typo_fields_group\":{\"font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"500\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":1.7},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"text\",\"id\":\"qx-text-7in2c\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"left\":15,\"right\":15},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"unit\":\"%\"}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-toe19\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"row\",\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"responsive_preview\":true,\"desktop\":{\"bottom\":60},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"id\":\"qx-row-qgp80\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"children\":[{\"name\":\"Person\",\"children\":[],\"slug\":\"person\",\"form\":{\"general\":{\"person_fg_image\":{\"image\":{\"source\":\"images\\/layout-pack\\/startup\\/team_img01.png\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"person_fg_details\":{\"pname\":\"Brooklyn Simmons\",\"position\":\"Finance Advisor\"}},\"styles\":{\"person_fg_panel\":{\"content_alignment\":{\"desktop\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"person_fg_image_style\":{\"image_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"img_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"img_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"img_background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"person_fg_name_style\":{\"name_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"name_color\":\"#00194C\",\"name_font\":{\"family\":\"Urbanist\",\"weight\":\"700\",\"size\":{\"desktop\":20},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_position_style\":{\"position_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"position_color\":\"#687799\",\"position_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_description_style\":{\"description_color\":\"#687799\",\"description_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":40,\"left\":30,\"bottom\":40,\"right\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":30,\"left\":30,\"bottom\":30,\"right\":30},\"border_width\":{\"top\":1,\"left\":1,\"bottom\":1,\"right\":1},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"#D4DCED\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"person\",\"id\":\"qx-person-nbat9\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-0xgdn\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Person\",\"children\":[],\"slug\":\"person\",\"form\":{\"general\":{\"person_fg_image\":{\"image\":{\"source\":\"images\\/layout-pack\\/startup\\/team_img02.png\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"person_fg_details\":{\"pname\":\"Jenny Wilson\",\"position\":\"Business Eng.\"}},\"styles\":{\"person_fg_panel\":{\"content_alignment\":{\"desktop\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"person_fg_image_style\":{\"image_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"img_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"img_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"img_background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"person_fg_name_style\":{\"name_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"name_color\":\"#00194C\",\"name_font\":{\"family\":\"Urbanist\",\"weight\":\"700\",\"size\":{\"desktop\":20},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_position_style\":{\"position_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"position_color\":\"#687799\",\"position_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_description_style\":{\"description_color\":\"#687799\",\"description_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":40,\"left\":30,\"bottom\":40,\"right\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":30,\"left\":30,\"bottom\":30,\"right\":30},\"border_width\":{\"top\":1,\"left\":1,\"bottom\":1,\"right\":1},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"#D4DCED\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"person\",\"id\":\"qx-person-o298j\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-wsrnx\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Person\",\"children\":[],\"slug\":\"person\",\"form\":{\"general\":{\"person_fg_image\":{\"image\":{\"source\":\"images\\/layout-pack\\/startup\\/team_img01.png\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"person_fg_details\":{\"pname\":\"Ronald Richards\",\"position\":\"Marketing\"}},\"styles\":{\"person_fg_panel\":{\"content_alignment\":{\"desktop\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"person_fg_image_style\":{\"image_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"img_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"img_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"img_background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"person_fg_name_style\":{\"name_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"name_color\":\"#00194C\",\"name_font\":{\"family\":\"Urbanist\",\"weight\":\"700\",\"size\":{\"desktop\":20},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_position_style\":{\"position_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"position_color\":\"#687799\",\"position_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_description_style\":{\"description_color\":\"#687799\",\"description_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":40,\"left\":30,\"bottom\":40,\"right\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":30,\"left\":30,\"bottom\":30,\"right\":30},\"border_width\":{\"top\":1,\"left\":1,\"bottom\":1,\"right\":1},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"#D4DCED\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"person\",\"id\":\"qx-person-gbnc1\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-45a76\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},{\"children\":[{\"name\":\"Person\",\"children\":[],\"slug\":\"person\",\"form\":{\"general\":{\"person_fg_image\":{\"image\":{\"source\":\"images\\/layout-pack\\/startup\\/team_img04.png\",\"base_domain\":\"https:\\/\\/getquix.net\\/\",\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}},\"link\":{\"url\":\"\",\"target\":\"\",\"nofollow\":false}},\"person_fg_details\":{\"pname\":\"Marvin McKinney\",\"position\":\"Developer\"}},\"styles\":{\"person_fg_panel\":{\"content_alignment\":{\"desktop\":\"center\"},\"content_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"person_fg_image_style\":{\"image_spacing\":{\"desktop\":15,\"tablet\":15,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"img_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"img_padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"img_background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"img_border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"person_fg_name_style\":{\"name_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"name_color\":\"#00194C\",\"name_font\":{\"family\":\"Urbanist\",\"weight\":\"700\",\"size\":{\"desktop\":20},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_position_style\":{\"position_spacing\":{\"desktop\":10,\"tablet\":10,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"},\"position_color\":\"#687799\",\"position_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}},\"person_fg_description_style\":{\"description_color\":\"#687799\",\"description_font\":{\"family\":\"Plus Jakarta Sans\",\"weight\":\"regular\",\"size\":{\"desktop\":16},\"spacing\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"px\"},\"height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"unit\":\"em\"},\"text_shadow\":{\"color\":\"\",\"blur\":10,\"horizontal\":0,\"vertical\":0}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"responsive_preview\":true,\"desktop\":{\"top\":40,\"left\":30,\"bottom\":40,\"right\":30},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_type\":\"solid\",\"border_radius\":{\"top\":30,\"left\":30,\"bottom\":30,\"right\":30},\"border_width\":{\"top\":1,\"left\":1,\"bottom\":1,\"right\":1},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"},\"border_color\":\"#D4DCED\"}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"label\":\"person\",\"id\":\"qx-person-qr8ar\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"column\",\"form\":{\"general\":{\"layout_fields_group\":{\"col_width\":{\"desktop\":25,\"tablet\":50,\"phone\":100},\"element_spacing\":{\"desktop\":20,\"tablet\":20,\"phone\":10,\"responsive_preview\":true,\"unit\":\"px\"}}},\"styles\":{\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}}},\"advanced\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"}},\"animation_fields_group\":{\"animation\":\"none\",\"animation_repeat\":false,\"animation_delay\":0},\"custom_css_group\":{\"custom_css\":{\"code\":\"\",\"mode\":\"css\"}},\"identifier\":{\"id\":\"qx-column-3s3k6\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"row\",\"form\":{\"general\":{\"layout_fields_group\":{\"custom_height\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}}},\"advanced\":{\"identifier\":{\"id\":\"qx-row-ajlef\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}],\"slug\":\"section\",\"form\":{\"general\":{\"layout_fields_group\":{\"container_width\":{\"desktop\":1140,\"tablet\":1140,\"phone\":1140,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"},\"v_align\":[]}},\"styles\":{\"spacing_fields_group\":{\"margin\":{\"desktop\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"tablet\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"},\"phone\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\"}},\"padding\":{\"desktop\":{\"top\":80,\"bottom\":80,\"left\":0,\"right\":0},\"phone\":{\"top\":20,\"bottom\":20,\"left\":0,\"right\":0},\"tablet\":{\"top\":40,\"bottom\":40,\"left\":0,\"right\":0}}},\"background_fields_group\":{\"background\":{\"state\":{\"normal\":{\"properties\":{\"required_parallax\":true,\"parallax\":true}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":false,\"parallax\":false,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}},\"poster\":{\"properties\":{\"size\":30,\"color\":\"rgba(0,0,0,1)\"},\"dimension\":{\"width\":\"\",\"height\":\"\"}}},\"background_overlay_fields_group\":{\"background_overlay\":{\"state\":{\"normal\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}},\"hover\":{\"properties\":{\"color_1\":\"\",\"color_2\":\"#f36\",\"type\":\"linear\",\"color\":\"\",\"url\":\"\",\"width\":\"\",\"height\":\"\",\"pause\":\"\",\"src\":\"\",\"size\":\"cover\",\"position\":\"center\",\"repeat\":\"no-repeat\",\"blend\":\"normal\",\"required_parallax\":true,\"parallax\":true,\"parallax_method\":\"css\",\"jsparallax\":true,\"direction\":0,\"start_position\":0,\"end_position\":100,\"overlay\":false,\"js_parallax_y\":\"\",\"js_parallax_x\":\"\"}}}}},\"border_fields_group\":{\"border\":{\"state\":{\"normal\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}},\"hover\":{\"properties\":{\"border_radius\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"border_width\":{\"top\":\"\",\"left\":\"\",\"bottom\":\"\",\"right\":\"\",\"unit\":\"px\"},\"box_shadow\":{\"color\":\"\",\"spread\":0,\"blur\":10,\"horizontal\":0,\"vertical\":0,\"position\":\"outline\"}}}}}},\"positioning_fields_group\":{\"horizontal_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"vertical_offset\":{\"desktop\":0,\"tablet\":0,\"phone\":0,\"responsive_preview\":true,\"unit\":\"px\"},\"custom_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_top_fields_group\":{\"top_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"top_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}},\"divider_bottom_fields_group\":{\"bottom_divider_width\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"%\"},\"bottom_divider_height\":{\"desktop\":100,\"tablet\":100,\"phone\":100,\"responsive_preview\":true,\"unit\":\"px\"}}},\"advanced\":{\"identifier\":{\"id\":\"qx-section-ernym\"}}},\"visibility\":{\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}}]}', '', '', '1', '2', '1', '2023-08-20 10:36:03', '964', '2023-08-21 07:54:20', '964', '0', '0000-00-00 00:00:00', '', '1', '0', '');/**ABDB**/
